/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tinyjee.maven.dim.utils.NodeListAdapter;
import org.tinyjee.maven.dim.utils.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathEvaluatorImplementation
implements XPathEvaluator {
    public static final String DEFAULT_PREFIX = "default";
    private final Node context;
    private final XPath xPath;

    public static String serializeNode(Node node, boolean omitDeclaration, boolean standalone) {
        try {
            StringWriter buffer = new StringWriter(4096);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (omitDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (standalone) {
                transformer.setOutputProperty("standalone", "yes");
            }
            transformer.transform(new DOMSource(node), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public XPathEvaluatorImplementation(final Document document) {
        this.context = document;
        this.xPath = XPathFactory.newInstance().newXPath();
        this.xPath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                return XPathEvaluatorImplementation.DEFAULT_PREFIX.equals(prefix) ? document.lookupNamespaceURI(null) : document.lookupNamespaceURI(prefix);
            }

            public String getPrefix(String namespaceURI) {
                return namespaceURI.equals(document.lookupNamespaceURI(null)) ? XPathEvaluatorImplementation.DEFAULT_PREFIX : document.lookupPrefix(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
            }
        });
    }

    private XPathEvaluatorImplementation(XPath xPath, Node context) {
        this.xPath = xPath;
        this.context = context;
    }

    @Override
    public String findText(String xpathExpression) {
        try {
            return (String)this.xPath.evaluate(xpathExpression, this.context, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Node> findNodes(String xpathExpression) {
        try {
            NodeList nodeList = (NodeList)this.xPath.evaluate(xpathExpression, this.context, XPathConstants.NODESET);
            return this.asList(nodeList);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String serialize(Node node) {
        return XPathEvaluatorImplementation.serializeNode(node, true, true);
    }

    @Override
    public List<Node> asList(NodeList nodeList) {
        return new NodeListAdapter(nodeList);
    }

    @Override
    public XPathEvaluator newEvaluator(Node node) {
        return new XPathEvaluatorImplementation(this.xPath, node);
    }
}

