/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 7547555631109691023L;

    public SelectableArrayList() {
    }

    public SelectableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SelectableArrayList(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public SelectableArrayList<E> clone() {
        return (SelectableArrayList)super.clone();
    }

    public SelectableArrayList<E> select(Selector<E> selector) {
        Object clone = this.clone();
        ((ArrayList)clone).clear();
        for (Object e : this) {
            if (!selector.accept(e)) continue;
            ((ArrayList)clone).add(e);
        }
        if (((ArrayList)clone).isEmpty() && !this.isEmpty()) {
            Log log = Globals.getLog();
            log.debug((CharSequence)("No elements were matched when selecting from " + this.size() + " elements by selector: " + selector));
        }
        return clone;
    }

    public SelectableArrayList<E> selectMatching(String regularExpression) {
        return this.select(this.createRegularExpressionSelector(regularExpression));
    }

    public SelectableArrayList<E> selectMatching(String ... regularExpressions) {
        ArrayList<Selector<E>> selectors = new ArrayList<Selector<E>>(regularExpressions.length);
        for (String regularExpression : regularExpressions) {
            selectors.add(this.createRegularExpressionSelector(regularExpression));
        }
        return this.select(this.createOrSelector(selectors.toArray(new Selector[selectors.size()])));
    }

    public SelectableArrayList<E> selectNonMatching(String regularExpression) {
        return this.select(this.createInvertSelector(this.createRegularExpressionSelector(regularExpression)));
    }

    public Selector<E> createOrSelector(final Selector<E> ... selectors) {
        return new Selector<E>(){

            @Override
            public boolean accept(E element) {
                for (Selector selector : selectors) {
                    if (!selector.accept(element)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "OrSelector{selectors=" + Arrays.toString(selectors) + '}';
            }
        };
    }

    public Selector<E> createInvertSelector(final Selector<E> other) {
        return new Selector<E>(){

            @Override
            public boolean accept(E element) {
                return !other.accept(element);
            }

            public String toString() {
                return "InvertSelector{selector=" + other + '}';
            }
        };
    }

    public Selector<E> createRegularExpressionSelector(final String regularExpression) {
        return new Selector<E>(){
            final Pattern pattern;
            {
                this.pattern = Pattern.compile(regularExpression);
            }

            @Override
            public boolean accept(E element) {
                return this.pattern.matcher(String.valueOf(element)).matches();
            }

            public String toString() {
                return "RegularExpressionSelector{pattern=" + this.pattern + '}';
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Selector<E> {
        public boolean accept(E var1);
    }
}

