/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 6815282986526871197L;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private final String name;

    public PrintableMap(String name) {
        this.name = name;
    }

    public PrintableMap(Map<? extends K, ? extends V> map, String name) {
        super(map);
        this.name = name;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value == null && !this.containsKey(key)) {
            String mapContent = this.getContentAsString();
            Log logger = Globals.getLog();
            logger.warn((CharSequence)("Didn't find the requested key '" + key + "' inside this '" + this.name + "' map." + NEWLINE + "Contained values are: " + mapContent));
        }
        return value;
    }

    public void printContent() {
        Globals.getLog().info((CharSequence)this.getContentAsString());
    }

    public String getContentAsString() {
        String mapContent = this.toString();
        StringTokenizer tokenizer = new StringTokenizer(mapContent, "{},", true);
        int indentDepth = 0;
        StringBuilder buffer = new StringBuilder(mapContent.length());
        block5: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case '{': {
                    buffer.append(token);
                    ++indentDepth;
                    continue block5;
                }
                case ',': {
                    buffer.append(token);
                    continue block5;
                }
                case '}': {
                    --indentDepth;
                }
            }
            buffer.append(NEWLINE);
            for (int i = 0; i < indentDepth; ++i) {
                buffer.append("   ");
            }
            buffer.append(token.trim());
        }
        mapContent = buffer.toString();
        return mapContent;
    }
}

