/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.tinyjee.maven.dim.spi.UrlFetcher;
import org.tinyjee.maven.dim.utils.AbstractPositioningDocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PositioningJsonDocumentBuilder
extends AbstractPositioningDocumentBuilder {
    public static final String ROOT_ELEMENT_TAG_NAME = "json";
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final JsonFactory jsonFactory = new JsonFactory();

    public PositioningJsonDocumentBuilder() {
        this.jsonFactory.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.documentBuilderFactory.setNamespaceAware(false);
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public Document parse(URL systemId) throws IOException, ParserConfigurationException {
        return this.parse(systemId, null);
    }

    public Document parse(URL systemId, Reader reader) throws IOException, ParserConfigurationException {
        JsonParser parser = this.jsonFactory.createJsonParser(reader == null ? UrlFetcher.getReadableSource(systemId) : reader);
        Document document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(ROOT_ELEMENT_TAG_NAME);
        document.setDocumentURI(systemId.toString());
        document.appendChild(rootElement);
        new DocumentTreeBuilder(document, rootElement, parser).buildDocumentTree();
        return document;
    }

    private static class DocumentTreeBuilder {
        private static final Pattern NON_TAG_NAME_CHARACTERS = Pattern.compile("[\\s<>&']+");
        private final Document document;
        private final Element rootElement;
        private final JsonParser parser;
        private final Stack<Element> elementStack = new Stack();
        private final Stack<Element> arrayStack = new Stack();
        private final Map<String, Element> stackElementOnArrayCreation = new HashMap<String, Element>();
        private JsonLocation currentLocation;
        private int lineNumber;
        private int lastLineNumber;
        private String currentName;

        private DocumentTreeBuilder(Document document, Element rootElement, JsonParser parser) {
            this.document = document;
            this.rootElement = rootElement;
            this.parser = parser;
        }

        void buildDocumentTree() throws IOException {
            Element previousField = null;
            JsonToken currentToken = this.parser.nextToken();
            while (currentToken != null) {
                this.currentLocation = this.parser.getCurrentLocation();
                this.lineNumber = this.currentLocation.getLineNr();
                this.currentName = this.parser.getCurrentName();
                switch (currentToken) {
                    case START_OBJECT: {
                        if (previousField != null) {
                            previousField.getParentNode().removeChild(previousField);
                            previousField = null;
                        }
                        if (!this.elementStack.isEmpty() && this.elementStack.peek().equals(this.stackElementOnArrayCreation.get(this.getArrayStackMappingKey()))) {
                            this.elementStack.push(this.addArrayElement());
                            break;
                        }
                        this.elementStack.push(this.addElement());
                        break;
                    }
                    case END_OBJECT: {
                        Element element = this.elementStack.pop();
                        if (element == null || !element.hasChildNodes()) break;
                        this.addWhitespaces(element, this.elementStack.size());
                        break;
                    }
                    case START_ARRAY: {
                        this.arrayStack.push(previousField);
                        this.recordArrayStackToElementMapping();
                        previousField = null;
                        break;
                    }
                    case END_ARRAY: {
                        this.stackElementOnArrayCreation.remove(this.getArrayStackMappingKey());
                        this.arrayStack.pop();
                        break;
                    }
                    case FIELD_NAME: {
                        previousField = this.addElement();
                        break;
                    }
                    case VALUE_FALSE: 
                    case VALUE_TRUE: 
                    case VALUE_NULL: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_STRING: {
                        if (previousField != null) {
                            previousField.setTextContent(this.parser.getText());
                            previousField = null;
                            break;
                        }
                        Element arrayElement = this.addArrayElement();
                        arrayElement.setTextContent(this.parser.getText());
                        this.addWhitespaces(arrayElement.getParentNode(), this.elementStack.size());
                    }
                }
                this.lastLineNumber = this.lineNumber;
                currentToken = this.parser.nextToken();
            }
        }

        private void recordArrayStackToElementMapping() {
            this.stackElementOnArrayCreation.put(this.getArrayStackMappingKey(), this.elementStack.peek());
        }

        private String getArrayStackMappingKey() {
            int size = this.arrayStack.size();
            return size + ":" + (size == 0 ? "" : this.arrayStack.peek().getTagName());
        }

        private Element addArrayElement() {
            Element arrayElement = this.arrayStack.peek();
            String textContent = arrayElement.getTextContent();
            if (textContent != null && textContent.length() != 0) {
                arrayElement = this.document.createElement(arrayElement.getTagName());
                this.fillInCurrentLocation(arrayElement);
                this.arrayStack.pop().getParentNode().appendChild(arrayElement);
                this.arrayStack.push(arrayElement);
            }
            this.recordArrayStackToElementMapping();
            return arrayElement;
        }

        private Element addElement() {
            Element parentNode = this.elementStack.isEmpty() ? null : this.elementStack.peek();
            String tagName = this.currentName == null ? "anonymous" : this.currentName;
            tagName = NON_TAG_NAME_CHARACTERS.matcher(tagName).replaceAll("_");
            Element element = parentNode == null ? this.rootElement : this.document.createElement(tagName);
            this.fillInCurrentLocation(element);
            this.addWhitespaces(parentNode, this.elementStack.size());
            if (parentNode != null) {
                parentNode.appendChild(element);
            }
            return element;
        }

        private void fillInCurrentLocation(Element element) {
            element.setUserData("lineNumber", this.lineNumber, null);
            element.setUserData("columnNumber", this.currentLocation.getColumnNr(), null);
        }

        private void addWhitespaces(Node parentNode, int indentCount) {
            if (parentNode != null) {
                for (int newLines = this.lineNumber - this.lastLineNumber; newLines > 0; --newLines) {
                    StringBuilder builder = new StringBuilder().append('\n');
                    for (int j = indentCount; j > 0; --j) {
                        builder.append("    ");
                    }
                    Text textNode = this.document.createTextNode(builder.toString());
                    parentNode.appendChild(textNode);
                }
            }
        }
    }
}

