/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.tinyjee.maven.dim.spi.UrlFetcher;
import org.tinyjee.maven.dim.utils.AbstractPositioningDocumentBuilder;
import org.tinyjee.maven.dim.utils.XhtmlEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.XMLFilterImpl;

public class PositioningDocumentBuilder
extends AbstractPositioningDocumentBuilder {
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public PositioningDocumentBuilder(boolean namespaceAware) {
        this.saxParserFactory.setNamespaceAware(namespaceAware);
    }

    public SAXParserFactory getSaxParserFactory() {
        return this.saxParserFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public Document parse(URL systemId) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        return this.parse(systemId, null);
    }

    public Document parse(URL systemIdUrl, Reader reader) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        String systemId = systemIdUrl.toString();
        boolean namespaceAware = this.saxParserFactory.isNamespaceAware();
        XMLReader xmlReader = this.saxParserFactory.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(new XhtmlEntityResolver());
        InputSource inputSource = reader == null ? new InputSource(UrlFetcher.getSource(systemIdUrl, false)) : new InputSource(reader);
        inputSource.setSystemId(systemId);
        SAXSource saxSource = new SAXSource(new LocationXmlFilter(xmlReader, namespaceAware), inputSource);
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult(null, systemId);
        transformer.transform(saxSource, domResult);
        Document document = (Document)domResult.getNode();
        PositioningDocumentBuilder.postProcessDocument(document, namespaceAware);
        return document;
    }

    private static void postProcessDocument(Document document, boolean namespaceAware) {
        NodeList allElements = namespaceAware ? document.getElementsByTagNameNS("*", "*") : document.getElementsByTagName("*");
        int length = allElements.getLength();
        for (int i = 0; i < length; ++i) {
            String[] locationParts;
            Node node;
            Node element = allElements.item(i);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes == null || (node = namespaceAware ? attributes.removeNamedItemNS(LocationXmlFilter.LOCATION_NS, "dim-element-location") : attributes.removeNamedItem("dim-element-location")) == null) continue;
            String location = node.getNodeValue();
            String[] stringArray = locationParts = location == null ? null : location.split(":");
            if (locationParts == null || locationParts.length <= 1) continue;
            element.setUserData("lineNumber", Integer.parseInt(locationParts[0]), null);
            element.setUserData("columnNumber", Integer.parseInt(locationParts[1]), null);
        }
    }

    private static class LocationXmlFilter
    extends XMLFilterImpl {
        static final String LOCATION_NS = LocationXmlFilter.class.getName();
        static final String LOCATION_ATTRIBUTE_QUALIFIED = "XdimlocX:dim-element-location";
        static final String LOCATION_ATTRIBUTE_LOCAL = "dim-element-location";
        static final String CDATA = "CDATA";
        private final boolean namespaceAware;
        private Locator locator;

        LocationXmlFilter(XMLReader xmlReader, boolean namespaceAware) {
            super(xmlReader);
            this.namespaceAware = namespaceAware;
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String location = this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
            JRE5SafeAttributes2Impl modifiedAttributes = new JRE5SafeAttributes2Impl(attributes);
            if (this.namespaceAware) {
                ((Attributes2Impl)modifiedAttributes).addAttribute(LOCATION_NS, LOCATION_ATTRIBUTE_LOCAL, LOCATION_ATTRIBUTE_QUALIFIED, CDATA, location);
            } else {
                ((Attributes2Impl)modifiedAttributes).addAttribute("", "", LOCATION_ATTRIBUTE_LOCAL, CDATA, location);
            }
            super.startElement(uri, localName, qName, modifiedAttributes);
        }

        private static class JRE5SafeAttributes2Impl
        extends Attributes2Impl {
            private static final Field declaredField;
            private static final Field specifiedField;

            JRE5SafeAttributes2Impl(Attributes attributes) {
                super(attributes);
            }

            public void addAttribute(String uri, String localName, String qName, String type, String value) {
                try {
                    super.addAttribute(uri, localName, qName, type, value);
                }
                catch (Exception ignored) {
                    try {
                        boolean[] specified = (boolean[])specifiedField.get(this);
                        boolean[] declared = (boolean[])declaredField.get(this);
                        int length = this.getLength();
                        if (specified == null) {
                            specified = new boolean[length];
                            declared = new boolean[length];
                        } else if (length > specified.length) {
                            boolean[] flags = new boolean[length];
                            System.arraycopy(declared, 0, flags, 0, declared.length);
                            declared = flags;
                            flags = new boolean[length];
                            System.arraycopy(specified, 0, flags, 0, specified.length);
                            specified = flags;
                        }
                        specified[length - 1] = true;
                        declared[length - 1] = !LocationXmlFilter.CDATA.equals(type);
                        specifiedField.set(this, specified);
                        declaredField.set(this, declared);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            static {
                try {
                    declaredField = Attributes2Impl.class.getDeclaredField("declared");
                    specifiedField = Attributes2Impl.class.getDeclaredField("specified");
                    for (Field field : Arrays.asList(declaredField, specifiedField)) {
                        field.setAccessible(true);
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

