/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbXmlSerializer<E> {
    public final String defaultSchemaBasename;
    public String namespace;
    private final JAXBContext jaxbContext;
    private final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    public JaxbXmlSerializer(String namespace, String defaultSchemaBasename, Class<? extends E> ... types) {
        this.defaultSchemaBasename = defaultSchemaBasename;
        if (namespace == null) {
            for (Class<E> clazz : types) {
                String string = namespace = clazz.isAnnotationPresent(XmlRootElement.class) ? clazz.getAnnotation(XmlRootElement.class).namespace() : null;
                if ("##default".equals(namespace)) {
                    namespace = null;
                }
                if (namespace != null) break;
            }
            if (namespace == null) {
                for (Class<E> clazz : types) {
                    String string = namespace = clazz.isAnnotationPresent(XmlType.class) ? clazz.getAnnotation(XmlType.class).namespace() : null;
                    if ("##default".equals(namespace)) {
                        namespace = null;
                    }
                    if (namespace != null) break;
                }
            }
            if (namespace == null) {
                namespace = "";
            }
        }
        this.namespace = namespace;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])types);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public JaxbXmlSerializer(Class<E> type) {
        this(type, null, type.getSimpleName().replaceAll("(?!^)([A-Z]+)", "-$1").toLowerCase());
    }

    public JaxbXmlSerializer(Class<E> type, String defaultSchemaBasename) {
        this(type, null, defaultSchemaBasename);
    }

    public JaxbXmlSerializer(Class<E> type, String namespace, String defaultSchemaBasename) {
        this(namespace, defaultSchemaBasename, type);
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public Map<String, Document> generateSchema() throws Exception {
        return this.generateSchema(this.defaultSchemaBasename);
    }

    public Map<String, Document> generateSchema(final String basename) throws Exception {
        final LinkedHashMap<String, Document> schemaFiles = new LinkedHashMap<String, Document>();
        final DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
        this.jaxbContext.generateSchema(new SchemaOutputResolver(){
            int fileId;

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                String xsdFile = basename + (++this.fileId > 1 ? "-" + this.fileId : "") + ".xsd";
                Document xsdDocument = builder.newDocument();
                xsdDocument.setDocumentURI(xsdFile);
                schemaFiles.put(xsdFile, xsdDocument);
                return new DOMResult((Node)xsdDocument, xsdDocument.getDocumentURI());
            }
        });
        return schemaFiles;
    }

    public E deserialize(Document document) throws Exception {
        return (E)this.jaxbContext.createUnmarshaller().unmarshal((Node)document);
    }

    public Document serialize(E instance, boolean includeSchema) throws Exception {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        if (includeSchema) {
            if (this.namespace == null || StringUtils.isEmpty((String)this.namespace)) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)(this.defaultSchemaBasename + ".xsd"));
            } else {
                marshaller.setProperty("jaxb.schemaLocation", (Object)(this.namespace + ' ' + this.defaultSchemaBasename + ".xsd"));
            }
        }
        Document document = this.builderFactory.newDocumentBuilder().newDocument();
        marshaller.marshal(instance, (Node)document);
        return document;
    }
}

