/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptFacade {
    protected static final Charset SCRIPT_ENCODING = Charset.forName("UTF-8");
    protected final Context context = ContextFactory.getGlobal().enterContext();
    protected final ScriptableObject scope;

    protected JavaScriptFacade() {
        this.context.setOptimizationLevel(9);
        this.scope = this.context.initStandardObjects();
    }

    protected void close() {
        Context.exit();
    }

    protected Scriptable createObject(Map<String, Object> values) {
        Scriptable object = this.context.newObject((Scriptable)this.scope);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            object.put(entry.getKey(), object, entry.getValue());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileScript(URL resource, List<Script> scripts) throws IOException {
        if (resource.getFile().endsWith(".zip")) {
            ZipInputStream zIn = new ZipInputStream(resource.openStream());
            try {
                this.compileScripts(zIn, scripts);
            }
            finally {
                zIn.close();
            }
        } else {
            scripts.add(this.compileScript(resource.getFile(), resource.openStream(), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileScripts(ZipInputStream zIn, List<Script> scripts) throws IOException {
        try {
            ZipEntry ze = zIn.getNextEntry();
            while (ze != null) {
                if (ze.getName().endsWith(".js")) {
                    scripts.add(this.compileScript(ze.getName(), zIn, false));
                }
                ze = zIn.getNextEntry();
            }
        }
        finally {
            zIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script compileScript(String name, InputStream in, boolean close) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(in, SCRIPT_ENCODING);
        try {
            Script script = this.context.compileReader((Reader)streamReader, name, 0, null);
            return script;
        }
        finally {
            if (close) {
                streamReader.close();
            }
        }
    }

    protected Object execute(Script script) {
        return script.exec(this.context, (Scriptable)this.scope);
    }

    protected Object getFromScope(String name) {
        return this.scope.get(name, (Scriptable)this.scope);
    }
}

