/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassLoader {
    private static final JavaClassLoader instance = new JavaClassLoader();
    private SoftReference<SharedBuildHolder> sharedBuilderReference = new SoftReference<Object>(null);
    private final Set<String> sourceUrls = new LinkedHashSet<String>();
    private final Set<String> sourceTrees = new LinkedHashSet<String>();

    public static JavaClassLoader getInstance() {
        return instance;
    }

    private JavaClassLoader() {
    }

    public synchronized JavaSource addSource(File basePath, String pathOrUrl) throws IOException {
        return this.addSource(basePath, pathOrUrl, false);
    }

    public synchronized JavaSource addSource(File basePath, String pathOrUrl, boolean doNotLoadSourceTree) throws IOException {
        return this.addSource(ResourceResolver.findSource(basePath, pathOrUrl), doNotLoadSourceTree);
    }

    public synchronized JavaSource addSource(URL sourceUrl, Reader sourceContent) {
        String sourceInfo = sourceUrl.toExternalForm();
        this.sourceUrls.add(sourceInfo);
        return this.getSharedBuilder(false).addSource(sourceContent, sourceInfo);
    }

    public synchronized JavaSource addSource(URL sourceUrl, boolean doNotLoadSourceTree) throws IOException {
        JavaSource javaSource = this.getSource(sourceUrl);
        if (javaSource != null) {
            return javaSource;
        }
        try {
            if (!doNotLoadSourceTree && "file".equals(sourceUrl.getProtocol())) {
                javaSource = this.createNewBuilder(true).addSource(sourceUrl);
                String packagePath = javaSource.getPackageName().replace('.', '/');
                String url = sourceUrl.toString();
                String rootUrl = "".equals(packagePath) ? sourceUrl.toURI().resolve(".").toASCIIString() : url.substring(0, url.indexOf(packagePath));
                File sourceFolder = new File(new URL(rootUrl).toURI());
                this.addSourceTree(sourceFolder);
                javaSource = this.getSource(sourceUrl);
                if (javaSource == null) {
                    Globals.getLog().warn((CharSequence)("Failed getting java source " + sourceUrl + " after adding source path " + sourceFolder + ", will load the source directly which may lead to duplicates when selecting JavaClasses later."));
                }
            }
            if (javaSource == null) {
                this.sourceUrls.add(sourceUrl.toString());
                javaSource = this.getSharedBuilder(false).addSource(sourceUrl);
            }
            return javaSource;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void addSourceTree(File sourceFolder) {
        if (this.sourceTrees.add(sourceFolder.toString())) {
            this.getSharedBuilder(false).addSourceTree(sourceFolder);
        }
    }

    public JavaSource getSource(URL sourceUrl) {
        try {
            String urlCharset = Globals.getInstance().getCharset().name();
            String urlString = sourceUrl.toExternalForm();
            String decodedUrlString = URLDecoder.decode(urlString, urlCharset);
            for (JavaSource javaSource : this.getSources()) {
                String otherUrlString;
                URL otherUrl = javaSource.getURL();
                String string = otherUrlString = otherUrl == null ? "" : otherUrl.toExternalForm();
                if (!otherUrlString.equals(urlString) && !otherUrlString.equals(decodedUrlString)) continue;
                return javaSource;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public synchronized JavaSource[] getSources() {
        return this.getSharedBuilder(true).getSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<JavaClass> getClasses() {
        JavaClass[] classes;
        JavaClassLoader javaClassLoader = this;
        synchronized (javaClassLoader) {
            classes = this.getSharedBuilder(true).getClasses();
        }
        return new TreeSet<JavaClass>(Arrays.asList(classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<JavaPackage> getPackages() {
        JavaPackage[] packages;
        JavaClassLoader javaClassLoader = this;
        synchronized (javaClassLoader) {
            packages = this.getSharedBuilder(true).getPackages();
        }
        TreeSet<JavaPackage> javaPackages = new TreeSet<JavaPackage>(new Comparator<JavaPackage>(){

            @Override
            public int compare(JavaPackage o1, JavaPackage o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        javaPackages.addAll(Arrays.asList(packages));
        return javaPackages;
    }

    public synchronized void clear() {
        this.sourceTrees.clear();
        this.sourceUrls.clear();
        this.sharedBuilderReference = new SoftReference<Object>(null);
    }

    JavaDocBuilder getSharedBuilder(boolean needsImmediateUpToDateCheck) {
        JavaDocBuilder builder;
        SharedBuildHolder holder = this.sharedBuilderReference.get();
        if (!needsImmediateUpToDateCheck) {
            this.scheduleUpToDateCheck();
        } else if (holder != null && !holder.isBuilderUpToDate()) {
            holder = null;
        }
        if (holder == null) {
            builder = this.createNewBuilder(false);
            this.sharedBuilderReference = new SoftReference<SharedBuildHolder>(new SharedBuildHolder(builder));
        } else {
            builder = holder.getBuilder();
        }
        return builder;
    }

    void scheduleUpToDateCheck() {
        SharedBuildHolder holder = this.sharedBuilderReference.get();
        if (holder != null) {
            holder.resetLastUpToDateCheck();
        }
    }

    synchronized JavaDocBuilder createNewBuilder(boolean forceEmpty) {
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        javaDocBuilder.setEncoding(Globals.getInstance().getCharset().name());
        if (!forceEmpty) {
            try {
                for (String sourceUrl : this.sourceUrls) {
                    javaDocBuilder.addSource(new URL(sourceUrl));
                }
                for (String sourceTree : this.sourceTrees) {
                    javaDocBuilder.addSourceTree(new File(sourceTree));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return javaDocBuilder;
    }

    private static class SharedBuildHolder {
        private static final int MS_BETWEEN_CHECKS = 1000;
        private final JavaDocBuilder builder;
        private long lastUpToDateCheck;
        private final Map<String, Long> sourceModifiedTimes = new HashMap<String, Long>();

        private SharedBuildHolder(JavaDocBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException("The wrapped builder cannot be set to 'null'");
            }
            this.builder = builder;
            this.isBuilderUpToDate();
        }

        JavaDocBuilder getBuilder() {
            return this.builder;
        }

        synchronized void resetLastUpToDateCheck() {
            this.lastUpToDateCheck = 0L;
        }

        synchronized boolean isBuilderUpToDate() {
            long time = System.currentTimeMillis();
            if (time - this.lastUpToDateCheck > 1000L) {
                JavaSource[] sources;
                for (JavaSource javaSource : sources = this.builder.getSources()) {
                    URL url = javaSource.getURL();
                    try {
                        if (url == null || !"file".equalsIgnoreCase(url.getProtocol())) continue;
                        String key = url.toString();
                        long sourceLastModified = url.openConnection().getLastModified();
                        Long capturedLastModified = this.sourceModifiedTimes.get(key);
                        if (capturedLastModified == null) {
                            this.sourceModifiedTimes.put(key, sourceLastModified);
                            continue;
                        }
                        if (capturedLastModified == sourceLastModified) continue;
                        return false;
                    }
                    catch (IOException e) {
                        Globals.getLog().warn((CharSequence)("Failed to get last modified date for URL " + url), (Throwable)e);
                    }
                }
                this.lastUpToDateCheck = time;
            }
            return true;
        }
    }
}

