/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private Iterator<E> current;
    private final Iterator<Iterator<E>> iterators;

    public CompositeIterator(Iterator<Iterator<E>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
            this.current = this.iterators.next();
        }
        return this.current != null && this.current.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    public String toString() {
        return "CompositeIterator{current=" + this.current + ", iterators=" + this.iterators + '}';
    }
}

