/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInputStream
extends InputStream {
    final Stack<InputStream> streams = new Stack();

    public CompositeInputStream(Collection<InputStream> streams) {
        InputStream[] inputStreams = streams.toArray(new InputStream[streams.size()]);
        for (int i = inputStreams.length - 1; i >= 0; --i) {
            this.streams.push(inputStreams[i]);
        }
    }

    public CompositeInputStream(InputStream ... streams) {
        this(Arrays.asList(streams));
    }

    @Override
    public int read() throws IOException {
        InputStream inputStream;
        int r = -1;
        while (!this.streams.empty() && (r = (inputStream = this.streams.peek()).read()) == -1) {
            this.streams.pop().close();
        }
        return r;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        InputStream inputStream;
        int r = -1;
        while (!this.streams.empty() && (r = (inputStream = this.streams.peek()).read(buffer, off, len)) == -1) {
            this.streams.pop().close();
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        IOException first = null;
        while (!this.streams.empty()) {
            try {
                this.streams.pop().close();
            }
            catch (IOException e) {
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }
}

