/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.utils;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.utils.PrintableMap;
import org.tinyjee.maven.dim.utils.SelectableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectableJavaEntitiesList<E>
extends SelectableArrayList<E> {
    private static final long serialVersionUID = -1293142697836984789L;
    static final Field javaClassIsAnnotationField;

    protected AbstractSelectableJavaEntitiesList() {
    }

    protected AbstractSelectableJavaEntitiesList(Collection<? extends E> collection) {
        super(collection);
    }

    protected abstract Object unwrap(E var1);

    protected final AbstractJavaEntity unwrapToEntity(E element) {
        Object rawEntity = this.unwrap(element);
        if (rawEntity instanceof BeanProperty) {
            JavaClass javaClass;
            BeanProperty property = (BeanProperty)rawEntity;
            JavaMethod method = property.getAccessor() == null ? property.getMutator() : property.getAccessor();
            JavaClass javaClass2 = javaClass = method == null ? null : method.getParentClass();
            if (javaClass != null) {
                JavaField fakeField = new JavaField(property.getType(), property.getName());
                fakeField.setParentClass(javaClass);
                fakeField.setModifiers(method.getModifiers());
                rawEntity = fakeField;
            }
        }
        return rawEntity instanceof AbstractJavaEntity ? (AbstractJavaEntity)rawEntity : null;
    }

    @Override
    public AbstractSelectableJavaEntitiesList<E> clone() {
        return (AbstractSelectableJavaEntitiesList)super.clone();
    }

    public Map<String, E> asMap() {
        PrintableMap mapView = new PrintableMap("Named-Java-Entities");
        for (Object element : this) {
            AbstractJavaEntity javaEntity = this.unwrapToEntity(element);
            if (javaEntity == null) continue;
            mapView.put(javaEntity.getName(), element);
            if (!(javaEntity instanceof JavaMethod)) continue;
            String callSignature = ((JavaMethod)javaEntity).getCallSignature();
            mapView.put(callSignature, element);
        }
        return mapView;
    }

    @Override
    public AbstractSelectableJavaEntitiesList<E> selectMatching(String entityExpression) {
        if (entityExpression.startsWith("!")) {
            return this.selectNonMatching(entityExpression.substring(1));
        }
        return (AbstractSelectableJavaEntitiesList)this.select(new SimpleEntitySelector(entityExpression));
    }

    @Override
    public AbstractSelectableJavaEntitiesList<E> selectNonMatching(String entityExpression) {
        if (entityExpression.startsWith("!")) {
            return this.selectMatching(entityExpression.substring(1));
        }
        return (AbstractSelectableJavaEntitiesList)this.select(this.createInvertSelector(new SimpleEntitySelector(entityExpression)));
    }

    public AbstractSelectableJavaEntitiesList<E> selectDerived(String classNameExpression) {
        return (AbstractSelectableJavaEntitiesList)this.select(new DerivedEntitySelector(classNameExpression));
    }

    public AbstractSelectableJavaEntitiesList<E> selectNonDerived(String classNameExpression) {
        return (AbstractSelectableJavaEntitiesList)this.select(this.createInvertSelector(new DerivedEntitySelector(classNameExpression)));
    }

    public AbstractSelectableJavaEntitiesList<E> selectAnnotated(String annotationNameExpression) {
        return (AbstractSelectableJavaEntitiesList)this.select(new AnnotatedEntitySelector(annotationNameExpression));
    }

    public AbstractSelectableJavaEntitiesList<E> selectNonAnnotated(String annotationNameExpression) {
        return (AbstractSelectableJavaEntitiesList)this.select(this.createInvertSelector(new AnnotatedEntitySelector(annotationNameExpression)));
    }

    public static boolean isAnnotation(JavaClass javaClass) {
        try {
            return (Boolean)javaClassIsAnnotationField.get(javaClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Pattern compileAOPLikeExpression(String expression) {
        String[] modifiers;
        expression = expression.trim();
        StringBuilder pattern = new StringBuilder(expression.length() + 16).append("^.*");
        if (expression.startsWith("@")) {
            int packageIndex = expression.indexOf(46);
            int braceIndex = expression.indexOf(40);
            if (packageIndex == -1 || braceIndex != -1 && packageIndex > braceIndex) {
                expression = "@.." + expression.substring(1);
            }
        }
        if ((modifiers = expression.split("\\s+")).length > 1) {
            for (int j = modifiers.length - 1; j > 0; --j) {
                pattern.append('(');
                int len = modifiers.length - 1;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        pattern.append('|');
                    }
                    pattern.append(Pattern.quote(modifiers[i]));
                }
                pattern.append(')');
            }
            pattern.append(".*");
            expression = modifiers[modifiers.length - 1];
        }
        StringTokenizer tokenizer = new StringTokenizer(expression.replace("..", "~"), "~*()", true);
        int openBraceCount = 0;
        block8: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case '*': {
                    pattern.append("[^\\s\\.\\$]*");
                    continue block8;
                }
                case '~': {
                    if (openBraceCount > 0) {
                        pattern.append(".*");
                        continue block8;
                    }
                    pattern.append(".*($|\\.|\\$)");
                    continue block8;
                }
                case '(': {
                    ++openBraceCount;
                    pattern.append("\\(");
                    continue block8;
                }
                case ')': {
                    --openBraceCount;
                    pattern.append("\\)");
                    continue block8;
                }
            }
            pattern.append(Pattern.quote(token));
        }
        if (pattern.charAt(pattern.length() - 1) == ')') {
            pattern.append(".*");
        }
        Pattern compiledPattern = Pattern.compile(pattern.append("$").toString());
        Globals.getLog().debug((CharSequence)("Compiled AOP like expression '" + expression + "' to the following regular expression: " + compiledPattern.pattern()));
        return compiledPattern;
    }

    static {
        try {
            javaClassIsAnnotationField = JavaClass.class.getDeclaredField("isAnnotation");
            javaClassIsAnnotationField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private class AnnotatedEntitySelector
    extends AbstractEntitySelector {
        AnnotatedEntitySelector(String annotationNameExpression) {
            super(annotationNameExpression.endsWith(")") ? annotationNameExpression : annotationNameExpression + "(..)");
        }

        boolean accept(AbstractJavaEntity entity) {
            for (Annotation annotation : entity.getAnnotations()) {
                if (!this.matches(annotation)) continue;
                return true;
            }
            return false;
        }
    }

    private class DerivedEntitySelector
    extends AbstractEntitySelector {
        DerivedEntitySelector(String classNameExpression) {
            super(classNameExpression);
        }

        boolean accept(AbstractJavaEntity entity) {
            if (entity instanceof JavaClass) {
                ArrayList<Type> typesToCheck = new ArrayList<Type>(Arrays.asList(((JavaClass)entity).getImplements()));
                typesToCheck.add(((JavaClass)entity).getSuperClass());
                for (Type type : typesToCheck) {
                    if (type == null || !this.matches(type) && !this.accept((AbstractJavaEntity)type.getJavaClass())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class SimpleEntitySelector
    extends AbstractEntitySelector {
        private SimpleEntitySelector(String entityExpression) {
            super(entityExpression);
        }

        boolean accept(AbstractJavaEntity entity) {
            return this.matches(entity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractEntitySelector
    implements SelectableArrayList.Selector<E> {
        final Log logger = Globals.getLog();
        final Pattern pattern;

        AbstractEntitySelector(String entityExpression) {
            this.pattern = entityExpression == null ? null : AbstractSelectableJavaEntitiesList.compileAOPLikeExpression(entityExpression);
        }

        @Override
        public boolean accept(E element) {
            AbstractJavaEntity javaEntity = AbstractSelectableJavaEntitiesList.this.unwrapToEntity(element);
            return javaEntity != null && this.accept(javaEntity);
        }

        @Override
        abstract boolean accept(AbstractJavaEntity var1);

        boolean matches(Object entity) {
            String entityString = this.entityToString(entity);
            boolean matches = this.pattern.matcher(entityString).matches();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)(this.pattern.pattern() + (matches ? " matches " : " does NOT match ") + entityString));
            }
            return matches;
        }

        String entityToString(Object entity) {
            if (entity instanceof JavaClass) {
                return this.toString((JavaClass)entity);
            }
            return entity.toString();
        }

        String toString(JavaClass entity) {
            StringBuilder result = new StringBuilder();
            this.appendModifiers((AbstractJavaEntity)entity, result);
            result.append(entity.isEnum() ? "enum " : (entity.isInterface() ? "interface " : (AbstractSelectableJavaEntitiesList.isAnnotation(entity) ? "@interface " : "class ")));
            result.append(entity.getFullyQualifiedName());
            return result.toString();
        }

        void appendModifiers(AbstractJavaEntity entity, StringBuilder result) {
            for (String modifier : entity.getModifiers()) {
                result.append(modifier).append(' ');
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + "pattern=" + this.pattern + '}';
        }
    }
}

