/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi.backport;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader {
    private ServiceLoader() {
    }

    public static <T> Iterable<T> load(Class<T> serviceType) {
        return new LazyIterable(serviceType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LazyIterable<T>
    implements Iterable<T> {
        private static final String PREFIX = "META-INF/services/";
        private final Class<T> serviceType;
        private final AtomicReference<List<T>> implementations = new AtomicReference();

        private LazyIterable(Class<T> serviceType) {
            this.serviceType = serviceType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<T> iterator() {
            if (this.implementations.get() == null) {
                try {
                    ArrayList<T> instances = new ArrayList<T>();
                    String[] resourceNames = new String[]{PREFIX + this.serviceType.getName(), this.serviceType.getName().replace('.', '/') + ".services"};
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = this.serviceType.getClassLoader();
                    }
                    for (String resourceName : resourceNames) {
                        Enumeration<URL> urls = classLoader.getResources(resourceName);
                        while (urls.hasMoreElements()) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(urls.nextElement().openStream(), "utf-8"));
                            try {
                                String implementation;
                                while ((implementation = reader.readLine()) != null) {
                                    int commentIndex = (implementation = implementation.trim()).indexOf(35);
                                    if (commentIndex != -1) {
                                        implementation = implementation.substring(0, commentIndex).trim();
                                    }
                                    if (implementation.length() == 0) continue;
                                    instances.add(this.serviceType.cast(classLoader.loadClass(implementation).newInstance()));
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                    }
                    this.implementations.compareAndSet(null, instances);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.implementations.get().iterator();
        }
    }
}

