/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.utils.CompositeInputStream;

public class UrlFetcher {
    public static final int MAX_CACHE_SIZE = 64;
    public static final int MAX_CACHED_CONTENT_SIZE = (int)Math.max(1048576.0, Math.min(2.147483647E9, 0.05 * (double)Runtime.getRuntime().maxMemory()));
    private static final Map<String, UrlContent> cache = new LinkedHashMap<String, UrlContent>(64, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, UrlContent> eldest) {
            return this.size() > 64;
        }
    };
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Map<String, byte[]> BYTE_ORDER_MARKS = new LinkedHashMap<String, byte[]>();

    private static synchronized UrlContent getUrlContent(URL sourceUrl) {
        String urlString = sourceUrl.toExternalForm();
        UrlContent urlContent = cache.get(urlString);
        if (urlContent == null) {
            urlContent = new UrlContent(sourceUrl);
            cache.put(urlString, urlContent);
        }
        return urlContent;
    }

    public static InputStream getSource(URL sourceUrl, boolean noCache) throws IOException {
        return UrlFetcher.getUrlContent(sourceUrl).openContent(noCache);
    }

    public static long getLastModified(URL sourceUrl) {
        return UrlFetcher.getUrlContent(sourceUrl).getLastModified();
    }

    public static boolean isModified(URL sourceUrl) {
        return UrlFetcher.getUrlContent(sourceUrl).isModified();
    }

    public static BufferedReader getReadableSource(URL sourceUrl) throws IOException {
        boolean noCache = Boolean.parseBoolean(String.valueOf(UrlFetcher.getRawRequestParameter("no-cache")));
        return UrlFetcher.getReadableSource(sourceUrl, noCache);
    }

    public static BufferedReader getReadableSource(URL sourceUrl, boolean noCache) throws IOException {
        Charset sourceCharset = UrlFetcher.getSourceCharset(sourceUrl);
        return new BufferedReader(new InputStreamReader(UrlFetcher.getSource(sourceUrl, noCache), sourceCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readerToString(Reader reader, boolean closeReader) throws IOException {
        try {
            int count;
            StringBuilder builder = new StringBuilder(512);
            char[] chars = new char[512];
            while ((count = reader.read(chars)) > 0) {
                builder.append(chars, 0, count);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            if (closeReader) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getSourceCharset(URL sourceUrl) {
        Charset charset;
        Log log;
        UrlContent urlContent;
        Globals globals;
        block11: {
            globals = Globals.getInstance();
            urlContent = UrlFetcher.getUrlContent(sourceUrl);
            log = globals.getLogger();
            charset = null;
            String sourceCharset = urlContent.sourceCharset;
            try {
                if (sourceCharset != null) {
                    charset = Charset.forName(sourceCharset);
                }
            }
            catch (Exception e) {
                log.warn((CharSequence)("Failed retrieving charset for name '" + sourceCharset + "', will attempt to use auto detection instead."));
                if (!log.isDebugEnabled()) break block11;
                log.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (charset == null) {
            charset = globals.getCharset();
            if (!globals.getCharsetIsUserSupplied() && !"false".equalsIgnoreCase(UrlFetcher.getCharsetAutoDetectParameter())) {
                try {
                    log.debug((CharSequence)("Starting charset auto detection on " + sourceUrl));
                    InputStream inputStream = urlContent.openContent(false);
                    try {
                        charset = UrlFetcher.autoDetectCharset(inputStream, charset);
                        if (charset != null) {
                            urlContent.sourceCharset = charset.name();
                        }
                        log.debug((CharSequence)("Auto detection returned the charset '" + charset + "' for " + sourceUrl));
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.warn((CharSequence)("Failed auto detecting charset for url '" + sourceUrl + "' using '" + charset + "' instead."), (Throwable)e);
                }
            }
        }
        return charset;
    }

    private static String getCharsetAutoDetectParameter() {
        Object rawValue = UrlFetcher.getRawRequestParameter("charset-autodetect");
        return rawValue == null ? null : String.valueOf(rawValue);
    }

    private static Object getRawRequestParameter(String name) {
        Globals globals = Globals.getInstance();
        return globals.getRequest() == null ? null : globals.getRequest().getParameter(name);
    }

    private static Charset autoDetectCharset(InputStream inputStream, Charset fallback) throws IOException {
        List<Object> probableCharsets;
        int read;
        final Log log = Globals.getLog();
        final AtomicReference exactMatch = new AtomicReference();
        nsDetector detector = new nsDetector();
        detector.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                log.debug((CharSequence)("Detected charset " + charset));
                exactMatch.set(Charset.forName(charset));
            }
        });
        boolean isAscii = true;
        String charsetFromBom = null;
        byte[] buffer = new byte[1024];
        int totalRead = 0;
        int maxRead = 131072;
        while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
            if (charsetFromBom == null && read > 0) {
                charsetFromBom = "";
                for (Map.Entry<String, byte[]> entry : BYTE_ORDER_MARKS.entrySet()) {
                    if (!ByteBuffer.wrap(entry.getValue()).equals(ByteBuffer.wrap(buffer, 0, Math.min(read, entry.getValue().length)))) continue;
                    charsetFromBom = entry.getKey();
                }
            }
            if (isAscii) {
                isAscii = detector.isAscii(buffer, read);
            }
            if ((isAscii || !detector.DoIt(buffer, read, false)) && (totalRead += read) <= maxRead) continue;
        }
        detector.DataEnd();
        if (isAscii) {
            return US_ASCII;
        }
        Charset charset = (Charset)exactMatch.get();
        String[] pc = detector.getProbableCharsets();
        List<Object> list = probableCharsets = pc == null ? Collections.emptyList() : Arrays.asList(pc);
        if (!StringUtils.isEmpty((String)charsetFromBom) && (probableCharsets.contains(charsetFromBom) || charset != null && charset.name().equals(charsetFromBom))) {
            log.debug((CharSequence)("Found UTF-BOM, assuming charset is " + charsetFromBom));
            charset = Charset.forName(charsetFromBom);
        }
        if (charset == null) {
            charset = fallback;
            if ("force".equalsIgnoreCase(UrlFetcher.getCharsetAutoDetectParameter()) && !probableCharsets.isEmpty()) {
                log.debug((CharSequence)("Could not detect correct charset for source, using first of probably charset " + probableCharsets));
                charset = Charset.forName((String)probableCharsets.get(0));
            } else {
                log.debug((CharSequence)("Charset detection did not find the right charset, using '" + charset + "' as fallback."));
            }
        }
        return charset;
    }

    private UrlFetcher() {
    }

    static {
        BYTE_ORDER_MARKS.put("UTF-8", new byte[]{-17, -69, -65});
        BYTE_ORDER_MARKS.put("UTF-16BE", new byte[]{-2, -1});
        BYTE_ORDER_MARKS.put("UTF-16LE", new byte[]{-1, -2});
        BYTE_ORDER_MARKS.put("UTF-32BE", new byte[]{0, 0, -2, -1});
        BYTE_ORDER_MARKS.put("UTF-32LE", new byte[]{-1, -2, 0, 0});
    }

    private static final class UrlContent {
        private final URL sourceUrl;
        private volatile boolean sourceIsOverSizeLimit;
        private volatile String sourceCharset;
        private volatile long cacheLastModified;
        private SoftReference<byte[]> cachedContent;

        private UrlContent(URL sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized InputStream openContent(boolean noCache) throws IOException {
            Log log = Globals.getLog();
            boolean debug = log.isDebugEnabled();
            InputStream contentStream = null;
            if (this.sourceIsOverSizeLimit) {
                if (debug) {
                    log.debug((CharSequence)("Returning un-cached, buffered input stream for oversized content from " + this.sourceUrl));
                }
                contentStream = new BufferedInputStream(this.sourceUrl.openStream(), 131072);
            } else {
                byte[] bytes;
                byte[] byArray = bytes = this.cachedContent == null || noCache ? null : this.cachedContent.get();
                if (bytes != null && this.isModified()) {
                    log.info((CharSequence)("The source " + this.sourceUrl + " was modified, flushing the cached content."));
                    bytes = null;
                }
                if (bytes == null) {
                    if (debug) {
                        log.debug((CharSequence)("Starting to buffer content from " + this.sourceUrl));
                    }
                    URLConnection urlConnection = this.sourceUrl.openConnection();
                    this.cacheLastModified = urlConnection.getLastModified();
                    this.sourceCharset = urlConnection.getContentEncoding();
                    if (debug && this.sourceCharset != null) {
                        log.debug((CharSequence)("Found source charset is " + this.sourceCharset));
                    }
                    InputStream inputStream = urlConnection.getInputStream();
                    try {
                        int r = 0;
                        byte[] transferBuffer = new byte[131072];
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        while ((r = inputStream.read(transferBuffer)) != -1) {
                            buffer.write(transferBuffer, 0, r);
                            if (buffer.size() <= MAX_CACHED_CONTENT_SIZE) continue;
                            this.sourceIsOverSizeLimit = true;
                            if (debug) {
                                log.debug((CharSequence)("Source " + this.sourceUrl + " exceeds max buffer size of " + MAX_CACHED_CONTENT_SIZE + " bytes."));
                            }
                            contentStream = new CompositeInputStream(new ByteArrayInputStream(buffer.toByteArray()), new BufferedInputStream(inputStream));
                            inputStream = null;
                            break;
                        }
                        if (contentStream == null) {
                            bytes = buffer.toByteArray();
                            this.cachedContent = new SoftReference<byte[]>(bytes);
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                if (bytes != null) {
                    if (debug) {
                        log.debug((CharSequence)("Returning cached content from " + this.sourceUrl));
                    }
                    contentStream = new ByteArrayInputStream(bytes);
                }
            }
            return contentStream;
        }

        boolean isModified() {
            return this.cacheLastModified != this.getLastModified();
        }

        long getLastModified() {
            if ("file".equalsIgnoreCase(this.sourceUrl.getProtocol())) {
                Log log = Globals.getLog();
                try {
                    return new File(this.sourceUrl.toURI()).lastModified();
                }
                catch (URISyntaxException ignored) {
                    log.warn((CharSequence)("Failed to look after last-modification for source " + this.sourceUrl + " could not convert the URL to a file"));
                }
            }
            return this.cacheLastModified;
        }

        public String toString() {
            return "UrlContent{sourceUrl=" + this.sourceUrl + ", cacheLastModified=" + new Date(this.cacheLastModified) + ", sourceIsOverSizeLimit=" + this.sourceIsOverSizeLimit + ", sourceCharset=" + this.sourceCharset + '}';
        }
    }
}

