/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.spi.FixedContentSource;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.SnippetSelector;
import org.tinyjee.maven.dim.spi.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnippetExtractor {
    public static final String LB = System.getProperty("line.separator", "\n");
    private static final String INDENT_CHARS = System.getProperty("org.tinyjee.maven.dim.indentChars", "\t ");
    private static final int[] INDENT_WIDTH;
    private static final Pattern EXPRESSION_SPLIT_PATTERN;
    private static final SnippetExtractor instance;

    public static SnippetExtractor getInstance() {
        return instance;
    }

    public String[] splitExpression(String expression) {
        int index = 0;
        String expressionPrefix = "";
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher matcher = EXPRESSION_SPLIT_PATTERN.matcher(expression);
        while (matcher.find()) {
            String match = expressionPrefix.concat(expression.substring(index, matcher.start()));
            if (match.length() != 0) {
                matchList.add(match);
            }
            index = matcher.end();
            expressionPrefix = matcher.group(1).trim();
            if (!expressionPrefix.startsWith(",")) continue;
            expressionPrefix = expressionPrefix.substring(1).trim();
        }
        if (index == 0) {
            return new String[]{expression};
        }
        if (index < expression.length()) {
            matchList.add(expressionPrefix.concat(expression.substring(index, expression.length())));
        } else if (expressionPrefix.length() > 0) {
            matchList.add(expressionPrefix);
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public boolean isSnippetSelectionRequired(Source source) {
        Map<String, Object> parameters = source.getContent().getParameters();
        return parameters.containsKey("snippet") || parameters.containsKey("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, List<String>> selectSnippets(Source source) throws IOException {
        SortedMap<Integer, List<String>> result;
        if (this.isSnippetSelectionRequired(source)) {
            List<SortedSet<Integer>> includesAndExcludes = this.findSelectedLines(source);
            Reader reader = source.getContent().openReader();
            try {
                result = this.extractSnippets(reader, (Set<Integer>)includesAndExcludes.get(0), (Set<Integer>)includesAndExcludes.get(1));
                this.unIndent(result, Boolean.parseBoolean(String.valueOf(source.getContent().getParameters().get("unindent-blocks"))));
            }
            finally {
                reader.close();
            }
        }
        Reader contentReader = source.getContent().openReader();
        try {
            result = this.convert(contentReader);
        }
        finally {
            contentReader.close();
        }
        return result;
    }

    public SortedMap<Integer, List<String>> extractSnippets(Reader reader, Set<Integer> includedLines, Set<Integer> excludedLines) throws IOException {
        String line;
        boolean isExcludeOnlyMode = includedLines.isEmpty() && !excludedLines.isEmpty();
        TreeMap<Integer, List<String>> result = new TreeMap<Integer, List<String>>();
        LineNumberReader lines = this.toLineNumberReader(reader);
        Integer lastIndex = null;
        while ((line = lines.readLine()) != null) {
            Integer lineNumber = lines.getLineNumber();
            if ((isExcludeOnlyMode || includedLines.contains(lineNumber)) && !excludedLines.contains(lineNumber)) {
                ArrayList<String> snippetLines;
                if (lastIndex == null) {
                    lastIndex = lineNumber;
                }
                if ((snippetLines = (ArrayList<String>)result.get(lastIndex)) == null) {
                    snippetLines = new ArrayList<String>(64);
                    result.put(lastIndex, snippetLines);
                }
                snippetLines.add(line);
                continue;
            }
            lastIndex = null;
        }
        return result;
    }

    public SortedMap<Integer, List<String>> convert(Reader contentReader) throws IOException {
        return this.extractSnippets(contentReader, Collections.<Integer>emptySet(), Collections.singleton(-1));
    }

    public String toString(Map<Integer, List<String>> content, boolean addEmptyLineBreaks) {
        int lastLineNumber = 1;
        StringBuilder out = new StringBuilder(255);
        for (Map.Entry<Integer, List<String>> entry : content.entrySet()) {
            int currentLineNumber;
            if (addEmptyLineBreaks && lastLineNumber < (currentLineNumber = entry.getKey().intValue())) {
                while (++lastLineNumber < currentLineNumber) {
                    out.append(LB);
                }
            }
            this.toString(entry.getValue(), out);
        }
        return out.toString();
    }

    public String toString(List<String> lines) {
        return this.toString(lines, new StringBuilder(100 * lines.size())).toString();
    }

    public StringBuilder toString(List<String> lines, StringBuilder out) {
        for (String line : lines) {
            if (out.length() > 0) {
                out.append(LB);
            }
            out.append(line);
        }
        return out;
    }

    public void unIndent(SortedMap<Integer, List<String>> snippetMap, boolean blockScope) {
        HashMap<Integer, Integer> minIndents = new HashMap<Integer, Integer>(snippetMap.size());
        if (blockScope) {
            for (Map.Entry<Integer, List<String>> entry : snippetMap.entrySet()) {
                minIndents.put(entry.getKey(), SnippetExtractor.minIndent(entry.getValue()));
            }
        } else {
            int minIndent = Integer.MAX_VALUE;
            for (List<String> lines : snippetMap.values()) {
                minIndent = Math.min(minIndent, SnippetExtractor.minIndent(lines));
            }
            for (Integer key : snippetMap.keySet()) {
                minIndents.put(key, minIndent);
            }
        }
        for (Map.Entry<Integer, List<String>> entry : snippetMap.entrySet()) {
            int minIndent = (Integer)minIndents.get(entry.getKey());
            ListIterator<String> iterator = entry.getValue().listIterator();
            while (iterator.hasNext()) {
                iterator.set(SnippetExtractor.unIndent(iterator.next(), minIndent));
            }
        }
    }

    String extractRawExpression(Map<String, Object> parameters) {
        Log log = Globals.getLog();
        String rawExpression = (String)parameters.get("snippet");
        if (parameters.containsKey("id")) {
            if (parameters.containsKey("snippet")) {
                log.warn((CharSequence)"Both snippet selection parameter, 'id' and 'snippet' found. Ignoring the value of 'id' as it was deprecated.");
            } else {
                String id = (String)parameters.get("id");
                log.warn((CharSequence)("Found deprecated snippet selection parameter 'id', please use 'snippet=#" + id + "' instead."));
                rawExpression = '#' + id;
            }
        }
        if (rawExpression == null) {
            throw new IllegalArgumentException("No snippet expression was defined in " + parameters + '.');
        }
        return rawExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SortedSet<Integer>> findSelectedLines(Source source) throws IOException {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        Source.Content content = source.getContent();
        Map<String, Object> parameters = content.getParameters();
        URL sourceUrl = source.getUrl() == null ? FixedContentSource.UNKNOWN : source.getUrl();
        String rawExpression = this.extractRawExpression(parameters);
        Object[] expressions = this.splitExpression(rawExpression);
        if (debug) {
            log.debug((CharSequence)("Extracting snippets using '" + rawExpression + "', parsed as " + Arrays.toString(expressions)));
        }
        TreeSet<Integer> includedLines = new TreeSet<Integer>();
        TreeSet<Integer> excludedLines = new TreeSet<Integer>();
        for (Object expression : expressions) {
            boolean isExclusion = ((String)expression).startsWith("!");
            if (isExclusion) {
                expression = ((String)expression).substring(1);
            }
            for (SnippetSelector selector : SnippetSelector.SELECTORS) {
                if (!selector.canSelectSnippetsWith((String)expression, sourceUrl, parameters)) continue;
                if (debug) {
                    log.debug((CharSequence)("About to " + (isExclusion ? "exclude" : "select") + " snippets with " + selector + " using expression " + (String)expression));
                }
                Reader reader = content.openReader();
                try {
                    TreeSet<Integer> addTo;
                    Iterator<Integer> linesIterator = selector.selectSnippets((String)expression, sourceUrl, this.toLineNumberReader(reader), parameters);
                    TreeSet<Integer> removeFrom = isExclusion ? includedLines : excludedLines;
                    TreeSet<Integer> treeSet = addTo = isExclusion ? excludedLines : includedLines;
                    while (linesIterator.hasNext()) {
                        Integer line = linesIterator.next();
                        removeFrom.remove(line);
                        addTo.add(line);
                    }
                }
                finally {
                    reader.close();
                }
                if (!debug) continue;
                log.debug((CharSequence)("Selected lines after processing selector:\n included:" + includedLines + "\n excluded:" + excludedLines));
            }
        }
        this.growSelectedLineOffsets(parameters, includedLines);
        if (Boolean.parseBoolean(String.valueOf(parameters.get("snippet-grow-excludes")))) {
            this.growSelectedLineOffsets(parameters, excludedLines);
        }
        List<SortedSet<Integer>> sets = Arrays.asList(includedLines, excludedLines);
        return sets;
    }

    void growSelectedLineOffsets(Map<String, Object> parameters, SortedSet<Integer> selectedLines) {
        int growStart = this.toInt(parameters.get("snippet-start-offset"), this.toInt(parameters.get("snippet-grow-offset"), 0));
        int growEnd = this.toInt(parameters.get("snippet-end-offset"), this.toInt(parameters.get("snippet-grow-offset"), 0));
        if (!(growStart <= 0 && growEnd <= 0 || selectedLines.isEmpty())) {
            int i;
            Integer currentLine = selectedLines.first();
            for (Integer lineNumber : selectedLines.toArray(new Integer[selectedLines.size()])) {
                if (!lineNumber.equals(currentLine) && lineNumber != currentLine + 1) {
                    int i2;
                    for (i2 = 1; i2 <= growEnd; ++i2) {
                        selectedLines.add(currentLine + i2);
                    }
                    for (i2 = 1; i2 <= growStart; ++i2) {
                        selectedLines.add(lineNumber - i2);
                    }
                }
                currentLine = lineNumber;
            }
            int line = selectedLines.first();
            for (i = 1; i <= growStart; ++i) {
                selectedLines.add(line - i);
            }
            line = selectedLines.last();
            for (i = 1; i <= growEnd; ++i) {
                selectedLines.add(line + i);
            }
        }
    }

    int toInt(Object value, int defaultValue) {
        return value == null ? defaultValue : (value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(String.valueOf(value)));
    }

    LineNumberReader toLineNumberReader(Reader reader) {
        return reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
    }

    static int minIndent(List<String> lines) {
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            minIndent = Math.min(minIndent, SnippetExtractor.detectIndentWith(line));
        }
        return minIndent;
    }

    static int detectIndentWith(String line) {
        int indent = 0;
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            int idx = INDENT_CHARS.indexOf(line.charAt(i));
            if (idx == -1) {
                return indent;
            }
            indent += INDENT_WIDTH[idx];
        }
        return Integer.MAX_VALUE;
    }

    static String unIndent(String line, int indentWidth) {
        int index;
        int indent = 0;
        int len = line.length();
        for (int i = 0; i < len && (index = INDENT_CHARS.indexOf(line.charAt(i))) != -1; ++i) {
            if ((indent += INDENT_WIDTH[index]) != indentWidth) continue;
            return line.substring(i + 1);
        }
        return line;
    }

    private SnippetExtractor() {
    }

    static {
        String[] widths = System.getProperty("org.tinyjee.maven.dim.indentWidths", "4, 1").split("\\s*,\\s*");
        INDENT_WIDTH = new int[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            SnippetExtractor.INDENT_WIDTH[i] = Integer.parseInt(widths[i]);
        }
        StringBuilder splitPattern = new StringBuilder();
        for (SnippetSelector selector : SnippetSelector.SELECTORS) {
            for (String prefix : selector.getExpressionPrefixes()) {
                splitPattern.append(splitPattern.length() == 0 ? (char)'(' : '|');
                splitPattern.append("(^|\\s*,)[\\s!]*").append(Pattern.quote(prefix));
            }
        }
        EXPRESSION_SPLIT_PATTERN = Pattern.compile(splitPattern.append(')').toString(), 2);
        instance = new SnippetExtractor();
    }
}

