/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceResolver {
    private static String currentClassLoaderKey;
    private static SoftReference<URLClassLoader> currentClassLoader;
    static final Pattern SPLITTER;
    static final String[] DEFAULT_SITE_SOURCE_SEARCH_PATH;
    static final String[] DEFAULT_SOURCE_SEARCH_PATH;
    static final String CLASSES_PATH;
    static final String TEST_CLASSES_PATH;

    public static void setModulePath(String groupId, String artifactId, File basePath) {
        String absolutePath = basePath.getAbsolutePath();
        System.setProperty("dim." + artifactId + ".basedir", absolutePath);
        System.setProperty("dim." + groupId + '_' + artifactId + ".basedir", absolutePath);
    }

    public static String getModulePath(String moduleName) {
        return System.getProperty("dim." + moduleName.replace(':', '_') + ".basedir");
    }

    public static Map<String, String> getModulePaths() {
        TreeMap<String, String> modulePaths = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            if (!key.startsWith("dim.") || !key.endsWith(".basedir")) continue;
            modulePaths.put('[' + key.substring(4, key.length() - 8).replace('_', ':') + ']', value);
        }
        return modulePaths;
    }

    static File[] canonicalizePath(File basePath, String path) {
        File[] result = new File[1];
        if (ResourceResolver.isAbsolute(path)) {
            result[0] = new File(path);
        } else {
            String base;
            try {
                base = basePath.getCanonicalPath();
            }
            catch (IOException e) {
                base = basePath.getAbsolutePath();
            }
            result = ResourceResolver.resolveDefaultProjectPaths("siteDirectory", "src/site", base, path, result);
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("sourceDirectory", "src/main/java", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("resourceDirectories", "src/main/resources", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("outputDirectory", "target/classes", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("testSourceDirectory", "src/test/java", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("testResourceDirectories", "src/test/resources", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("testOutputDirectory", "target/test-classes", base, path, result);
            }
            if (result[0] == null) {
                result = ResourceResolver.resolveDefaultProjectPaths("targetDirectory", "target", base, path, result);
            }
            if (result[0] == null) {
                result[0] = new File(basePath, path);
            }
        }
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = result[i].getCanonicalFile();
                continue;
            }
            catch (IOException e) {
                Log log = Globals.getLog();
                log.warn((CharSequence)("Failed to retrieve the canonical path of " + result[i] + '.'));
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    static File[] resolveDefaultProjectPaths(String projectPathKey, String projectPathPrefix, String basePath, String path, File[] result) {
        String projectPath;
        if (((path = path.replace('\\', '/')).equals(projectPathPrefix) || path.startsWith(projectPathPrefix + '/')) && !StringUtils.isEmpty((String)(projectPath = System.getProperty("org.tinyjee.maven.dim.project." + projectPathKey)))) {
            Log log = Globals.getLog();
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(StringUtils.split((String)projectPath, (String)File.pathSeparator)));
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String pp = (String)iterator.next();
                if (ResourceResolver.isPathBelowBase(basePath, pp)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Ignoring project path '" + projectPathKey + ':' + pp + "' is not below the given " + "search base path of '" + basePath + '\''));
                }
                iterator.remove();
            }
            if (!paths.isEmpty()) {
                result = result.length == paths.size() ? result : new File[paths.size()];
                int len = paths.size();
                for (int i = 0; i < len; ++i) {
                    result[i] = new File((String)paths.get(i) + File.separator + path.substring(projectPathPrefix.length()));
                }
            }
        }
        return result;
    }

    private static boolean isPathBelowBase(String basePath, String path) {
        if (!ResourceResolver.isAbsolute(basePath)) {
            return false;
        }
        if (!ResourceResolver.isAbsolute(path)) {
            return false;
        }
        path = path.replace('\\', '/').trim();
        basePath = basePath.replace('\\', '/').trim();
        boolean caseSensitive = File.separatorChar == '/';
        return caseSensitive ? path.startsWith(basePath) : path.toLowerCase().startsWith(basePath.toLowerCase());
    }

    public static List<File> buildDefaultSearchPaths(File basePath, String ... proposedPaths) {
        ArrayList<File> searchPaths = new ArrayList<File>();
        File[] basePaths = new File[]{basePath, new File(".")};
        ArrayList<String[]> partialPaths = new ArrayList<String[]>();
        if (proposedPaths != null && proposedPaths.length > 0) {
            for (int i = 0; i < proposedPaths.length; ++i) {
                proposedPaths[i] = ResourceResolver.toFilePath(proposedPaths[i]);
            }
            partialPaths.add(proposedPaths);
        }
        partialPaths.add(DEFAULT_SITE_SOURCE_SEARCH_PATH);
        partialPaths.add(DEFAULT_SOURCE_SEARCH_PATH);
        partialPaths.add(new String[]{""});
        for (File path : basePaths) {
            if (path == null) continue;
            Iterator i$ = partialPaths.iterator();
            while (i$.hasNext()) {
                String[] paths;
                for (String pp : paths = (String[])i$.next()) {
                    if (pp == null) continue;
                    for (File searchPath : ResourceResolver.canonicalizePath(path, pp)) {
                        if (!searchPath.exists() || searchPaths.contains(searchPath)) continue;
                        searchPaths.add(searchPath.getAbsoluteFile());
                    }
                }
            }
        }
        return searchPaths;
    }

    public static boolean isAbsolute(String filePath) {
        if (filePath == null) {
            return false;
        }
        if (filePath.startsWith("/") || filePath.startsWith("\\")) {
            return true;
        }
        return File.pathSeparatorChar != ':' && filePath.length() > 1 && filePath.charAt(1) == ':';
    }

    public static String toFilePath(String source) {
        if (source != null && !ResourceResolver.isAbsolute(source = source.replace('\\', '/'))) {
            try {
                URI sourceURI = new URI(source);
                if (sourceURI.getScheme() != null) {
                    source = "file".equalsIgnoreCase(sourceURI.getScheme()) ? sourceURI.getPath() : null;
                }
            }
            catch (URISyntaxException ignored) {
                Globals.getLog().debug((CharSequence)(source + " is not a file path, processing it as URL."));
            }
        }
        return source;
    }

    public static void findMatchingPaths(List<File> searchPaths, String source, List<URL> results) {
        if ((source = ResourceResolver.toFilePath(source)) == null) {
            return;
        }
        for (File searchPath : searchPaths) {
            File file = new File(searchPath, source);
            if (!file.exists()) continue;
            try {
                URL url = file.toURI().toURL();
                if (results.contains(url)) continue;
                results.add(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void findMatchingURLs(File basePath, String source, List<URL> results) {
        if (ResourceResolver.isAbsolute(source)) {
            return;
        }
        try {
            if (source.startsWith("[") && source.contains("]:")) {
                String moduleName = source.substring(1, source.indexOf("]:"));
                String path = ResourceResolver.getModulePath(moduleName);
                if (path != null) {
                    List<File> searchPaths = ResourceResolver.buildDefaultSearchPaths(new File(path), new String[0]);
                    ResourceResolver.findMatchingPaths(searchPaths, source.substring(moduleName.length() + 3), results);
                    ResourceResolver.assertHasResult(source, results, "below the paths", searchPaths);
                } else {
                    ResourceResolver.assertHasResult(source, results, "below the module base paths", ResourceResolver.getModulePaths().entrySet());
                }
            } else {
                URI sourceURI = new URI(source);
                String scheme = sourceURI.getScheme();
                if (scheme != null && !"file".equalsIgnoreCase(scheme)) {
                    if ("classpath".equalsIgnoreCase(scheme)) {
                        URLClassLoader ucl = ResourceResolver.resolveClassLoader(basePath);
                        String path = sourceURI.getPath();
                        if (path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        Enumeration<URL> e = ucl.getResources(path);
                        while (e.hasMoreElements()) {
                            URL url = e.nextElement();
                            if (results.contains(url)) continue;
                            results.add(url);
                        }
                        ResourceResolver.assertHasResult(source, results, "inside Maven's site building classpath nor below the paths", Arrays.asList(ucl.getURLs()));
                    } else {
                        results.add(sourceURI.toURL());
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            Globals.getLog().debug((CharSequence)(source + " points to an invalid or broken classpath."), (Throwable)e);
        }
        catch (Exception ignored) {
            Globals.getLog().debug((CharSequence)(source + " is not an URI, not resolving it as URL."));
        }
    }

    public static URL findSource(File basePath, String source) {
        Log log = Globals.getLog();
        List<URL> results = ResourceResolver.findAllSources(basePath, source);
        if (results.size() > 1) {
            for (int i = results.size() - 1; i > 0; --i) {
                URL url = results.get(i);
                if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
                url = results.set(0, url);
                results.set(i, url);
                log.info((CharSequence)("Found multiple matching sources " + results + " for " + source + ", preferring the local file over others."));
            }
            log.warn((CharSequence)("Found matching sources @ " + results + " for " + source + ", using the first match."));
        } else if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Found matching source @ " + results + " for " + source + '.'));
        }
        return results.get(0);
    }

    public static List<URL> findAllSources(File basePath, String source) {
        ArrayList<URL> results = new ArrayList<URL>();
        ResourceResolver.findMatchingURLs(basePath, source, results);
        if (results.isEmpty()) {
            List<File> searchPaths = ResourceResolver.buildDefaultSearchPaths(basePath, new String[0]);
            ResourceResolver.findMatchingPaths(searchPaths, source, results);
            ResourceResolver.assertHasResult(source, results, "below the paths", searchPaths);
        }
        return results;
    }

    private static void assertHasResult(String source, List<URL> results, String where, Collection<?> searchPaths) {
        if (results.isEmpty()) {
            String separator = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder().append("Didn't find ");
            builder.append('\'').append(source).append("' ").append(where).append(": ");
            for (Object path : searchPaths) {
                builder.append(separator).append("-- ").append(path);
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    public static Class<?> resolveClass(File basePath, String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            URLClassLoader loader = ResourceResolver.resolveClassLoader(basePath);
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalArgumentException("Didn't find the source class '" + className + "' inside Maven's site building classpath nor below the paths: " + Arrays.asList(loader.getURLs()), e1);
            }
        }
    }

    public static synchronized URLClassLoader resolveClassLoader(File basePath) {
        if (basePath == null) {
            return (URLClassLoader)ResourceResolver.class.getClassLoader();
        }
        String clKey = basePath.getAbsolutePath();
        URLClassLoader ulc = currentClassLoader.get();
        if (ulc == null || currentClassLoaderKey == null || !currentClassLoaderKey.equals(clKey)) {
            try {
                String projectTestClassPath;
                LinkedHashSet<String> classpath = new LinkedHashSet<String>();
                classpath.add(System.getProperty("org.tinyjee.maven.dim.project.outputDirectory", new File(basePath, CLASSES_PATH).getAbsolutePath()));
                classpath.add(System.getProperty("org.tinyjee.maven.dim.project.testOutputDirectory", new File(basePath, TEST_CLASSES_PATH).getAbsolutePath()));
                String projectClassPath = System.getProperty("org.tinyjee.maven.dim.include.project.classpath");
                if (projectClassPath != null) {
                    Collections.addAll(classpath, StringUtils.split((String)projectClassPath, (String)File.pathSeparator));
                }
                if ((projectTestClassPath = System.getProperty("org.tinyjee.maven.dim.include.project.test.classpath")) != null) {
                    Collections.addAll(classpath, StringUtils.split((String)projectTestClassPath, (String)File.pathSeparator));
                }
                Globals.getLog().debug((CharSequence)("Creating a new classloader to load classes via 'source-class', using the classpath:" + classpath));
                int i = 0;
                URL[] urls = new URL[classpath.size()];
                for (String file : classpath) {
                    urls[i++] = new File(file).toURI().toURL();
                }
                ulc = new URLClassLoader(urls, ResourceResolver.class.getClassLoader());
                currentClassLoader = new SoftReference<URLClassLoader>(ulc);
                currentClassLoaderKey = clKey;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to build search path to lookup .class files.", e);
            }
        }
        return ulc;
    }

    public static File findSiteSourceDirectory(File baseDir, File proposedSiteDir) {
        Log log = Globals.getLog();
        List<File> paths = ResourceResolver.buildDefaultSearchPaths(baseDir, proposedSiteDir == null ? null : proposedSiteDir.getAbsolutePath());
        for (File file : paths) {
            if (!"site".equals(file.getName())) continue;
            log.debug((CharSequence)("Using '" + file + "/resources', to append CSS style sheets."));
            return file;
        }
        log.debug((CharSequence)("Didn't find site directory below " + paths + ", will inline CSS styles."));
        return null;
    }

    private ResourceResolver() {
    }

    static {
        currentClassLoader = new SoftReference<Object>(null);
        SPLITTER = Pattern.compile("\\s*[,;]+\\s*", 8);
        DEFAULT_SITE_SOURCE_SEARCH_PATH = SPLITTER.split(System.getProperty("org.tinyjee.maven.dim.siteSourceSearchPath", "src/site, src/site/resources, site, site/resources"));
        DEFAULT_SOURCE_SEARCH_PATH = SPLITTER.split(System.getProperty("org.tinyjee.maven.dim.sourceSearchPath", "src/main/java, src/main/resources, src/test/java, src/test/resources, src/main, src, target"));
        CLASSES_PATH = System.getProperty("org.tinyjee.maven.dim.include.classesPath", "target/classes/");
        TEST_CLASSES_PATH = System.getProperty("org.tinyjee.maven.dim.include.testClassesPath", "target/test-classes/");
    }
}

