/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.SystemStreamLog;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.spi.UrlFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Globals {
    static final String LB = System.getProperty("line.separator", "\n");
    private static final Map<Sink, Set<String>> attachedResources = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Sink, AtomicInteger> localIdSequences = Collections.synchronizedMap(new WeakHashMap());
    private static final AtomicInteger idSequence = new AtomicInteger();
    private static final ThreadLocal<Stack<Globals>> threadLocal = new ThreadLocal<Stack<Globals>>(){

        @Override
        protected Stack<Globals> initialValue() {
            return new Stack<Globals>();
        }
    };
    private Charset charset = Charset.defaultCharset();
    private boolean charsetIsUserSupplied;
    private final MacroRequest request;
    private final File attachedIncludesPath;
    private final Sink sink;
    private Log logger;

    public static Globals initializeGlobals(String charset, Sink sink, MacroRequest request, Log logger, File attachedIncludesPath) {
        Globals globals = new Globals(charset, sink, request, logger, attachedIncludesPath);
        threadLocal.get().push(globals);
        return globals;
    }

    public static Globals reInitializeGlobals(String charset, Sink sink, MacroRequest request, Log logger, File attachedIncludesPath) {
        threadLocal.get().pop();
        return Globals.initializeGlobals(charset, sink, request, logger, attachedIncludesPath);
    }

    public static void cleanupGlobals() {
        Stack<Globals> globalsStack = threadLocal.get();
        globalsStack.pop();
        if (globalsStack.empty()) {
            threadLocal.remove();
        }
    }

    public static Globals getInstance() {
        Stack<Globals> globalsStack = threadLocal.get();
        return globalsStack.empty() ? new Globals(null, null, null, null, null) : globalsStack.peek();
    }

    public static Log getLog() {
        return Globals.getInstance().getLogger();
    }

    public static String getAttachedIncludesDirectory() {
        return System.getProperty("org.tinyjee.maven.dim.attachedIncludesDirectory", "attached-includes").replace('\\', '/');
    }

    private Globals(String charset, Sink sink, MacroRequest request, Log logger, File attachedIncludesPath) {
        this.sink = sink;
        this.request = request;
        this.logger = logger;
        this.attachedIncludesPath = attachedIncludesPath;
        this.charsetIsUserSupplied = charset != null;
        if (this.charsetIsUserSupplied) {
            this.charset = Charset.forName(charset);
        } else {
            String inputEncoding = System.getProperty("org.tinyjee.maven.dim.project.inputEncoding");
            if (!StringUtils.isEmpty((String)inputEncoding)) {
                this.charset = Charset.forName(inputEncoding);
            }
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean getCharsetIsUserSupplied() {
        return this.charsetIsUserSupplied;
    }

    public Log getLogger() {
        if (this.logger == null) {
            this.logger = new SystemStreamLog();
        }
        return this.logger;
    }

    public int nextId() {
        return idSequence.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextLocalId() {
        AtomicInteger idSequence;
        Map<Sink, AtomicInteger> map = localIdSequences;
        synchronized (map) {
            idSequence = localIdSequences.get(this.sink);
            if (idSequence == null) {
                idSequence = new AtomicInteger();
                localIdSequences.put(this.sink, idSequence);
            }
        }
        return idSequence.incrementAndGet();
    }

    public Sink getSink() {
        return this.sink;
    }

    public Globals operateOnSink(Sink sink) {
        if (sink == null || sink == this.sink) {
            return this;
        }
        Globals globals = new Globals(null, sink, this.request, this.logger, this.attachedIncludesPath);
        globals.charset = this.charset;
        globals.charsetIsUserSupplied = this.charsetIsUserSupplied;
        return globals;
    }

    public boolean isHTMLCapableSink() {
        try {
            return this.sink instanceof HtmlMarkup;
        }
        catch (NoClassDefFoundError ignored) {
            String[] names = new String[]{"XhtmlSink", "XhtmlBaseSink"};
            for (Class<?> cls = this.sink.getClass(); cls != null; cls = cls.getSuperclass()) {
                for (String name : names) {
                    if (!cls.getName().contains(name)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public MacroRequest getRequest() {
        return this.request;
    }

    public File getBasedir() {
        return this.request == null ? new File(".") : this.request.getBasedir();
    }

    public File getAttachedIncludesPath() {
        return this.attachedIncludesPath;
    }

    public URL resolvePath(String path) {
        return ResourceResolver.findSource(this.getBasedir(), path);
    }

    public File resolveLocalPath(String localPath) {
        URL url = this.resolvePath(localPath);
        try {
            return "file".equalsIgnoreCase(url.getProtocol()) ? new File(url.toURI()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] fetchUrl(URL url) throws IOException {
        InputStream inputStream = UrlFetcher.getSource(url, false);
        return IOUtil.toByteArray((InputStream)inputStream);
    }

    public byte[] fetch(String path) throws IOException {
        return this.fetchUrl(this.resolvePath(path));
    }

    public String fetchUrlText(URL url) throws IOException {
        return UrlFetcher.readerToString(UrlFetcher.getReadableSource(url), true);
    }

    public String fetchText(String path) throws IOException {
        return this.fetchUrlText(this.resolvePath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAttachedResources() {
        Map<Sink, Set<String>> map = attachedResources;
        synchronized (map) {
            Set<String> resources = attachedResources.get(this.sink);
            if (resources == null) {
                resources = new HashSet<String>();
                attachedResources.put(this.sink, resources);
            }
            return resources;
        }
    }

    public boolean attachCss(String fileName, String cssContent) throws IOException {
        Set<String> resources = this.getAttachedResources();
        if (resources.contains(fileName)) {
            Globals.getLog().debug((CharSequence)("Will not attach a CSS of name '" + fileName + "' twice within the same output."));
            return true;
        }
        if (this.isHTMLCapableSink()) {
            String link;
            StringBuilder html = new StringBuilder(64).append("<style type=\"text/css\">").append(LB);
            String string = link = StringUtils.isEmpty((String)fileName) ? null : this.attachContent(fileName, cssContent);
            if (link == null) {
                if (cssContent.startsWith("classpath:")) {
                    cssContent = IOUtil.toString((Reader)UrlFetcher.getReadableSource(this.resolvePath(cssContent)));
                }
                html.append(cssContent);
            } else {
                html.append("   @import url('").append(link).append("');");
            }
            html.append(LB).append("</style>").append(LB);
            this.sink.rawText(html.toString());
            if (!StringUtils.isEmpty((String)fileName)) {
                resources.add(fileName);
            }
            return true;
        }
        return false;
    }

    public boolean attachJs(String fileName, String scriptContent) throws IOException {
        return this.attachScript(fileName, scriptContent, null, null);
    }

    public boolean attachScript(String fileName, String scriptContent, String scriptLanguage, String contentType) throws IOException {
        Set<String> resources = this.getAttachedResources();
        if (resources.contains(fileName)) {
            Globals.getLog().debug((CharSequence)("Will not attach a Script of name '" + fileName + "' twice within the same output."));
            return true;
        }
        if (this.isHTMLCapableSink()) {
            String link;
            if (scriptLanguage == null) {
                scriptLanguage = "javascript";
            }
            if (contentType == null) {
                contentType = "text/javascript";
            }
            StringBuilder html = new StringBuilder(64).append("<script type=\"").append(contentType).append("\" language=\"").append(scriptLanguage).append('\"');
            String string = link = StringUtils.isEmpty((String)fileName) ? null : this.attachContent(fileName, scriptContent);
            if (link == null) {
                if (scriptContent.startsWith("classpath:")) {
                    scriptContent = IOUtil.toString((Reader)UrlFetcher.getReadableSource(this.resolvePath(scriptContent)));
                }
                html.append('>').append(LB).append(scriptContent).append(LB);
            } else {
                html.append(" src=\"").append(link).append("\">");
            }
            html.append("</script>").append(LB);
            this.sink.rawText(html.toString());
            if (!StringUtils.isEmpty((String)fileName)) {
                resources.add(fileName);
            }
            return true;
        }
        return false;
    }

    public String attachContent(String fileName, String content) throws IOException {
        CharsetEncoder charsetEncoder;
        if (this.attachedIncludesPath == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)content)) {
            throw new IllegalArgumentException("Cannot attach 'null'. No content was specified.");
        }
        if (content.startsWith("classpath:")) {
            return this.attachBinaryContent(fileName, content);
        }
        Log log = Globals.getLog();
        Charset charset = this.getCharset();
        Charset utf8 = Charset.forName("UTF-8");
        if (content.trim().startsWith("<")) {
            Matcher matcher = Pattern.compile("\\<\\?xml.*encoding=['\"]{1}(.+)['\"]{1}").matcher(content);
            if (matcher.find()) {
                charset = Charset.forName(matcher.group(1));
            } else if (content.contains("/>") || !content.contains("<html")) {
                charset = utf8;
            }
        }
        if (!(charsetEncoder = this.getCharset().newEncoder()).canEncode(content)) {
            log.warn((CharSequence)("The selected charset of '" + charset.name() + "' cannot be used to encode the specified content. " + "Will change the charset to '" + utf8 + '\''));
            charset = utf8;
            charsetEncoder = charset.newEncoder();
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Selected charset for '" + fileName + "' using '" + charset + '\''));
        }
        try {
            ByteBuffer buffer = charsetEncoder.encode(CharBuffer.wrap(content));
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array(), buffer.arrayOffset(), buffer.remaining());
            return this.attachBinaryContent(fileName, stream);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Content that will not be stored:" + LB + content));
            }
            throw e;
        }
    }

    public String attachBinaryContent(String url) throws IOException {
        return this.attachBinaryContent(this.resolvePath(url));
    }

    public String attachBinaryContent(String fileName, String url) throws IOException {
        return this.attachBinaryContent(fileName, this.resolvePath(url));
    }

    public String attachBinaryContent(URL sourceUrl) throws IOException {
        return this.attachBinaryContent(sourceUrl.getPath(), sourceUrl);
    }

    public String attachBinaryContent(String fileName, URL sourceUrl) throws IOException {
        return this.attachBinaryContent(fileName, UrlFetcher.getSource(sourceUrl, false));
    }

    public String attachBinaryContent(String fileName, byte[] binaryContent) throws IOException {
        return this.attachBinaryContent(fileName, new ByteArrayInputStream(binaryContent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachBinaryContent(String fileName, InputStream binaryContent) throws IOException {
        File targetFile;
        if (this.attachedIncludesPath == null) {
            return null;
        }
        if (binaryContent == null) {
            throw new IllegalArgumentException("Cannot attach 'null'. Binary content is not specified.");
        }
        if (StringUtils.isEmpty((String)fileName)) {
            throw new IllegalArgumentException("Cannot attach binary content '" + binaryContent + "' when filename is empty.");
        }
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        File path = this.attachedIncludesPath.getCanonicalFile();
        try {
            targetFile = Globals.createTargetFile(path, fileName);
        }
        catch (IOException e) {
            IOException ioException = new IOException("Failed building target path to attach file " + fileName + " under base path " + path);
            ioException.initCause(e);
            throw ioException;
        }
        if (debug) {
            log.debug((CharSequence)("About to store content to '" + targetFile + '\''));
        }
        File compressedTargetFile = new File(targetFile + ".gz");
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        try {
            GZIPOutputStream compressedOutputStream = new GZIPOutputStream(new FileOutputStream(compressedTargetFile));
            try {
                int read = 0;
                byte[] buffer = new byte[65536];
                while ((read = binaryContent.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, read);
                    ((OutputStream)compressedOutputStream).write(buffer, 0, read);
                }
            }
            finally {
                ((OutputStream)compressedOutputStream).close();
            }
        }
        finally {
            ((OutputStream)outputStream).close();
        }
        double compressionRatio = (double)compressedTargetFile.length() / (double)targetFile.length();
        if (compressionRatio > 0.95) {
            if (debug) {
                log.debug((CharSequence)("The size of '" + compressedTargetFile + "' is " + Math.round(100.0 * compressionRatio) + "% the size of the uncompressed file, removing the compressed version as it is no improvement."));
            }
            if (!compressedTargetFile.delete()) {
                compressedTargetFile.deleteOnExit();
            }
        } else if (debug) {
            log.debug((CharSequence)("Generated a compressed version of the attached content '" + compressedTargetFile + "' having " + Math.round(100.0 * compressionRatio) + "% the size of the uncompressed file."));
        }
        this.getAttachedResources().add(fileName);
        URI baseUri = Globals.createBaseUri(path);
        return baseUri.relativize(targetFile.toURI()).toASCIIString();
    }

    private static URI createBaseUri(File path) {
        String attachedIncludesDirectory = Globals.getAttachedIncludesDirectory();
        if (!StringUtils.isEmpty((String)attachedIncludesDirectory)) {
            String pathString = path.getAbsolutePath().replace('\\', '/');
            if (pathString.endsWith(attachedIncludesDirectory)) {
                pathString = pathString.substring(0, pathString.length() - attachedIncludesDirectory.length());
            }
            return new File(pathString).toURI();
        }
        return path.toURI();
    }

    static File createTargetFile(File path, String fileName) throws IOException {
        Log log = Globals.getLog();
        if (fileName.matches("^[a-zA-Z]{2,}:[/]{1,3}.+")) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("The given filename '" + fileName + "' seems to be an URI, trying to extract the URI path for use as " + "filename instead of the complete URI."));
            }
            if ((fileName = URI.create(fileName).getPath()).contains("!/")) {
                fileName = fileName.substring(fileName.indexOf("!/") + 2);
            }
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if (fileName.matches("^[a-zA-Z]{1}:.+")) {
            fileName = fileName.substring(2);
        }
        File targetFile = new File(path, fileName).getCanonicalFile();
        File targetDirectory = targetFile.getParentFile();
        if (!targetFile.getAbsolutePath().startsWith(path.getAbsolutePath())) {
            throw new IllegalArgumentException("Cannot store target file " + targetFile + " as it is not located below " + path);
        }
        if (targetDirectory == null || !targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            log.warn((CharSequence)("Cannot create target directory '" + targetDirectory + "' to store content for file '" + fileName + '\''));
            throw new IllegalArgumentException("Cannot store target file " + targetFile + " as the parent " + "directory does not exist and cannot be created. Parent directory is " + targetDirectory);
        }
        return targetFile;
    }

    public String toString() {
        return "Globals{charset=" + this.charset + ", charsetIsUserSupplied=" + this.charsetIsUserSupplied + ", request=" + this.request + ", attachedIncludesPath=" + this.attachedIncludesPath + ", sink=" + this.sink + ", logger=" + this.logger + '}';
    }
}

