/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.spi;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tinyjee.maven.dim.spi.Source;
import org.tinyjee.maven.dim.spi.UrlFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSource
implements Source {
    protected final URL sourceUrl;
    protected final Map<String, Object> parameters;

    protected AbstractSource(URL sourceUrl, Map<String, Object> parameters) {
        this.sourceUrl = sourceUrl;
        this.parameters = new HashMap<String, Object>(parameters == null ? Collections.emptyMap() : parameters);
    }

    @Override
    public URL getUrl() {
        return this.sourceUrl;
    }

    @Override
    public Source.Content getContent() {
        return new SourceContent();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "sourceUrl=" + this.sourceUrl + ", parameters=" + this.parameters + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SourceContent
    implements Source.Content {
        protected SourceContent() {
        }

        @Override
        public Map<String, Object> getParameters() {
            return Collections.unmodifiableMap(AbstractSource.this.parameters);
        }

        @Override
        public Reader openReader() throws IOException {
            return AbstractSource.this.sourceUrl == null ? null : UrlFetcher.getReadableSource(AbstractSource.this.sourceUrl);
        }

        public String toString() {
            return "SourceContent{super=" + AbstractSource.this.toString() + '}';
        }
    }
}

