/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.tinyjee.maven.dim.sources.AbstractSnippetSelector;
import org.tinyjee.maven.dim.utils.AbstractPositioningDocumentBuilder;
import org.tinyjee.maven.dim.utils.PositioningDocumentBuilder;
import org.tinyjee.maven.dim.utils.PositioningJsonDocumentBuilder;
import org.tinyjee.maven.dim.utils.XPathEvaluatorImplementation;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathSnippetSelector
extends AbstractSnippetSelector {
    public static final String NAMESPACE_AWARE = "namespace-aware";

    public XPathSnippetSelector() {
        this("xp:");
    }

    protected XPathSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        expression = this.stripPrefix(expression);
        boolean contentIsJson = contentUrl.getPath().toLowerCase().endsWith(".json") || "json".equalsIgnoreCase(String.valueOf(macroParameters.get("source-content-type")));
        AbstractPositioningDocumentBuilder documentBuilder = contentIsJson ? new PositioningJsonDocumentBuilder() : new PositioningDocumentBuilder(Boolean.parseBoolean(String.valueOf(macroParameters.get(NAMESPACE_AWARE))));
        try {
            TreeSet<Integer> selectedLines = new TreeSet<Integer>();
            XPathEvaluatorImplementation evaluator = new XPathEvaluatorImplementation(documentBuilder.parse(contentUrl, content));
            for (Node node : evaluator.findNodes(expression)) {
                int firstLine = AbstractPositioningDocumentBuilder.getLineNumber(node);
                int newLines = new StringTokenizer(evaluator.serialize(node), "\n").countTokens();
                for (int i = 0; i < newLines; ++i) {
                    selectedLines.add(firstLine + i);
                }
            }
            return selectedLines.iterator();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }
}

