/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.tools.config.DefaultKey;
import org.tinyjee.maven.dim.sh.CodeHighlighter;
import org.tinyjee.maven.dim.sources.AbstractParametricVelocityTool;
import org.tinyjee.maven.dim.spi.SnippetExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultKey(value="highlighter")
public class VelocityHighlightingTool
extends AbstractParametricVelocityTool<VelocityHighlightingTool> {
    private static final Pattern[] codeBlocksPatterns = new Pattern[]{Pattern.compile("(<code><pre>)(.+?)(</pre></code>)", 42), Pattern.compile("(<pre><code>)(.+?)(</code></pre>)", 42)};
    private final URL unknown = new URL("file:///unknown");
    private CodeHighlighter highlighter;

    private CodeHighlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new CodeHighlighter();
        }
        return this.highlighter;
    }

    private Map<String, String> nextInvocationParameters(Map<Integer, List<String>> content) {
        return this.getHighlighter().buildHighlighterParams(this.unknown, content, this.nextInvocationParameters());
    }

    public String highlight(String code) {
        return this.highlight(null, code);
    }

    public String highlight(String brush, String code) {
        try {
            CodeHighlighter codeHighlighter = this.getHighlighter();
            codeHighlighter.attachStylesheet(null, this.nextInvocationParameters());
            SortedMap<Integer, List<String>> content = SnippetExtractor.getInstance().convert(new StringReader(code));
            Map<String, String> params = this.nextInvocationParameters(content);
            if (brush == null) {
                brush = codeHighlighter.findBrushName(this.unknown, content, params);
            }
            return codeHighlighter.highlight(brush, code, params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String highlightCodeBlocks(String contentWithCodeBlocks) {
        return this.highlightCodeBlocks(null, contentWithCodeBlocks);
    }

    public String highlightCodeBlocks(String brush, String contentWithCodeBlocks) {
        for (Pattern pattern : codeBlocksPatterns) {
            Matcher matcher = pattern.matcher(contentWithCodeBlocks);
            StringBuffer result = new StringBuffer(contentWithCodeBlocks.length() + 256);
            while (matcher.find()) {
                matcher.appendReplacement(result, this.highlight(brush, matcher.group(2)));
            }
            matcher.appendTail(result);
            contentWithCodeBlocks = result.toString();
        }
        return contentWithCodeBlocks;
    }

    public String java(String code) {
        return this.highlight("java", code);
    }

    public String js(String code) {
        return this.highlight("js", code);
    }

    public String css(String code) {
        return this.highlight("css", code);
    }

    public String xml(String code) {
        return this.highlight("xml", code);
    }

    public String jsp(String code) {
        return this.highlight("html/jsp", code);
    }
}

