/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.sources.AbstractStreamingSnippetSelector;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAndBraceSnippetSelector
extends AbstractStreamingSnippetSelector {
    public static final Map<String, String> BRACES;

    public TokenAndBraceSnippetSelector() {
        this("tb:");
    }

    protected TokenAndBraceSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        expression = this.stripPrefix(expression);
        final Map.Entry<String, String> braceStyle = this.findBraceStyle(expression);
        if (expression.endsWith(braceStyle.getKey())) {
            expression = expression.substring(0, expression.length() - braceStyle.getKey().length());
        }
        final int fixedLineNumber = this.extractFixedLineNumber(expression);
        final boolean caseSensitive = Boolean.parseBoolean(String.valueOf(macroParameters.get("case-sensitive")));
        return new AbstractStreamingSnippetSelector.AbstractStreamIterator<String>(caseSensitive ? expression : expression.toLowerCase(Locale.ENGLISH), content){
            int braceOpenCount;
            final String openingBrace;
            final String closingBrace;
            {
                super(x0, x1);
                this.openingBrace = (String)braceStyle.getKey();
                this.closingBrace = (String)braceStyle.getValue();
            }

            @Override
            protected boolean isCapturingLine(boolean alreadyCapturing, String expression, String line, int lineNumber) {
                if (alreadyCapturing) {
                    if (this.braceOpenCount < 0) {
                        this.braceOpenCount = 0;
                        return false;
                    }
                    int openBraces = TokenAndBraceSnippetSelector.this.countTokens(line, this.openingBrace);
                    int closeBraces = TokenAndBraceSnippetSelector.this.countTokens(line, this.closingBrace);
                    if (this.braceOpenCount == 0 && openBraces == 0) {
                        return true;
                    }
                    this.braceOpenCount += openBraces - closeBraces;
                    if (this.braceOpenCount <= 0) {
                        this.braceOpenCount = -1;
                    }
                    return true;
                }
                boolean tokenIsPresent = fixedLineNumber == lineNumber || (StringUtils.isEmpty((String)expression) ? line.contains(this.openingBrace) : (caseSensitive ? line.contains(expression) : line.toLowerCase(Locale.ENGLISH).contains(expression)));
                return tokenIsPresent && this.isCapturingLine(true, expression, line, lineNumber);
            }
        };
    }

    protected int extractFixedLineNumber(String expression) {
        if (expression.startsWith("[") && expression.endsWith("]")) {
            try {
                return Integer.parseInt(expression.substring(1, expression.length() - 1));
            }
            catch (NumberFormatException e) {
                Globals.getLog().warn((CharSequence)("A line number token was used that contained an invalid numeric expression: " + expression + ", will fallback to string based token processing."), (Throwable)e);
            }
        }
        return -1;
    }

    protected int countTokens(String line, String token) {
        int count = 0;
        int position = -token.length();
        while ((position = line.indexOf(token, position + token.length())) > -1) {
            ++count;
        }
        return count;
    }

    protected Map.Entry<String, String> findBraceStyle(String expression) {
        Map.Entry<String, String> defaultEntry = null;
        for (Map.Entry<String, String> entry : BRACES.entrySet()) {
            if (expression.endsWith(entry.getKey())) {
                return entry;
            }
            defaultEntry = entry;
        }
        return defaultEntry;
    }

    static {
        LinkedHashMap<String, String> braces = new LinkedHashMap<String, String>();
        braces.put("<!--", "-->");
        braces.put("/*", "*/");
        braces.put("#*", "*#");
        braces.put("[", "]");
        braces.put("(", ")");
        braces.put("<", ">");
        braces.put("{", "}");
        BRACES = Collections.unmodifiableMap(braces);
    }
}

