/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.maven.doxia.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.EasyFactoryConfiguration;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.tinyjee.maven.dim.sources.AbstractBufferedSource;
import org.tinyjee.maven.dim.sources.UrlSource;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.Source;
import org.tinyjee.maven.dim.spi.UrlFetcher;
import org.tinyjee.maven.dim.spi.VelocityConfigurator;

public class TemplateSource
extends AbstractBufferedSource {
    static final String TEMPLATE_ENCODING = "UTF-8";
    static final String TEMPLATE_PARAM_SOURCE_URL = "sourceUrl";
    private static final ThreadLocal<VelocityEngine> engineEnvironment = new ThreadLocal<VelocityEngine>(){

        @Override
        protected VelocityEngine initialValue() {
            try {
                VelocityEngine ve = new VelocityEngine();
                ve.setProperty("runtime.log.logsystem", (Object)new TemplateLogger());
                for (VelocityConfigurator configurator : VelocityConfigurator.CONFIGURATORS) {
                    configurator.configureEngine(ve);
                }
                ve.init();
                return ve;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    static final ToolManager VELOCITY_TOOL_MANAGER;
    final Source source;
    final VelocityEngine engine = engineEnvironment.get();
    Template template;

    private static void deleteTemporaryFile(File file) {
        if (file != null && !file.delete()) {
            Globals.getLog().warn((CharSequence)("Failed to delete temporary file: " + file + ", trying to delete on exit."));
            file.deleteOnExit();
        }
    }

    public TemplateSource(URL sourceUrl, Source source) {
        super(sourceUrl, null);
        this.source = source;
    }

    protected void writeSourceContent(Writer writer) throws IOException {
        Source.Content sourceContent = this.source.getContent();
        this.parameters.putAll(sourceContent.getParameters());
        if (this.template == null) {
            this.createTemplate(sourceContent);
        }
        this.renderContent(writer);
    }

    private void renderContent(Writer writer) throws IOException {
        ToolContext toolContext = VELOCITY_TOOL_MANAGER.createContext();
        if (this.sourceUrl != null) {
            toolContext.put(TEMPLATE_PARAM_SOURCE_URL, (Object)this.sourceUrl);
        }
        VelocityContext context = new VelocityContext(this.parameters, (Context)toolContext);
        for (VelocityConfigurator configurator : VelocityConfigurator.CONFIGURATORS) {
            configurator.configureContext(new HashMap<String, Object>(this.parameters), (Context)context);
        }
        this.template.merge((Context)context, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemplate(Source.Content sourceContent) {
        UrlSource urlSource = this.source instanceof UrlSource ? (UrlSource)this.source : null;
        File templateFile = null;
        try {
            block7: {
                try {
                    if (urlSource != null) {
                        String charset = UrlFetcher.getSourceCharset(urlSource.getUrl()).name();
                        this.template = this.engine.getTemplate(urlSource.getUrl().toExternalForm(), charset);
                        break block7;
                    }
                    File temporaryFolder = this.sourceUrl != null && "file".equalsIgnoreCase(this.sourceUrl.getProtocol()) ? new File(this.sourceUrl.toURI()).getParentFile() : null;
                    String temporaryNamePrefix = this.sourceUrl == null ? "inline-content-" : FileUtils.basename((String)new File(this.sourceUrl.getPath()).getName()) + '-';
                    templateFile = File.createTempFile(temporaryNamePrefix, ".vm", temporaryFolder);
                    OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(templateFile), TEMPLATE_ENCODING);
                    try {
                        IOUtil.copy((Reader)sourceContent.openReader(), (Writer)output);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        output.close();
                        throw throwable;
                    }
                    output.close();
                    this.template = this.engine.getTemplate(templateFile.toURI().toASCIIString(), TEMPLATE_ENCODING);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            TemplateSource.deleteTemporaryFile(templateFile);
            throw throwable;
        }
        TemplateSource.deleteTemporaryFile(templateFile);
    }

    static {
        EasyFactoryConfiguration config = new EasyFactoryConfiguration();
        for (VelocityConfigurator configurator : VelocityConfigurator.CONFIGURATORS) {
            configurator.configureTools(config);
        }
        config.autoLoad();
        ToolManager toolManager = new ToolManager(false, false);
        toolManager.configure((FactoryConfiguration)config);
        toolManager.setUserCanOverwriteTools(true);
        VELOCITY_TOOL_MANAGER = toolManager;
    }

    private static class TemplateLogger
    implements LogChute {
        private TemplateLogger() {
        }

        public void init(RuntimeServices runtimeServices) throws Exception {
        }

        public void log(int i, String s) {
            this.log(i, s, null);
        }

        public void log(int i, String s, Throwable throwable) {
            Log log = Globals.getLog();
            switch (i) {
                case -1: 
                case 0: {
                    if (throwable == null) {
                        log.debug((CharSequence)s);
                        break;
                    }
                    log.debug((CharSequence)s, throwable);
                    break;
                }
                case 1: {
                    if (throwable == null) {
                        log.debug((CharSequence)s);
                        break;
                    }
                    log.info((CharSequence)s, throwable);
                    break;
                }
                case 2: {
                    if (throwable == null) {
                        log.warn((CharSequence)s);
                        break;
                    }
                    log.warn((CharSequence)s, throwable);
                    break;
                }
                case 3: {
                    if (throwable == null) {
                        log.error((CharSequence)s);
                        break;
                    }
                    log.error((CharSequence)s, throwable);
                }
            }
        }

        public boolean isLevelEnabled(int i) {
            Log log = Globals.getLog();
            switch (i) {
                case -1: 
                case 0: {
                    return log.isDebugEnabled();
                }
                case 1: {
                    return log.isInfoEnabled();
                }
            }
            return true;
        }
    }

    public static class UrlResourceLoader
    extends ResourceLoader {
        public void init(ExtendedProperties extendedProperties) {
        }

        public InputStream getResourceStream(String sourceUrl) throws ResourceNotFoundException {
            try {
                return UrlFetcher.getSource(new URL(sourceUrl), false);
            }
            catch (Exception ignored) {
                try {
                    return UrlFetcher.getSource(Globals.getInstance().resolvePath(sourceUrl), false);
                }
                catch (Exception e) {
                    if ("VM_global_library.vm".equals(sourceUrl)) {
                        Globals.getLog().debug((CharSequence)("A global default VM library '" + sourceUrl + "' was not found. Will run without it."));
                        return new ByteArrayInputStream(new byte[0]);
                    }
                    throw new ResourceNotFoundException(sourceUrl, (Throwable)e);
                }
            }
        }

        public boolean isSourceModified(Resource resource) {
            try {
                return UrlFetcher.isModified(new URL(resource.getName()));
            }
            catch (MalformedURLException ignored) {
                return false;
            }
        }

        public long getLastModified(Resource resource) {
            try {
                return UrlFetcher.getLastModified(new URL(resource.getName()));
            }
            catch (MalformedURLException ignored) {
                return 0L;
            }
        }
    }
}

