/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.tinyjee.maven.dim.sources.AbstractBufferedSource;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.spi.SnippetExtractor;
import org.tinyjee.maven.dim.spi.Source;

public class SourceClassAdapter
extends AbstractBufferedSource {
    public static final String LEGACY_CONTENT_MAP_KEY = "content";
    final Class<?> cls;
    final File basePath;
    final boolean classProvidesOwnContent;

    public SourceClassAdapter(File basePath, Map requestParams, String className) {
        super(null, requestParams);
        this.basePath = basePath;
        this.cls = ResourceResolver.resolveClass(basePath, className);
        this.classProvidesOwnContent = Source.Content.class.isAssignableFrom(this.cls);
    }

    public synchronized Source.Content getContent() {
        if (this.content == null && this.classProvidesOwnContent) {
            this.content = (Source.Content)this.instantiateClass(this.basePath, this.parameters);
        }
        return super.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSourceContent(Writer writer) throws IOException {
        Object instance = this.instantiateClass(this.basePath, this.parameters);
        Reader sourceContent = null;
        if (instance instanceof Map) {
            String content;
            this.parameters.clear();
            this.parameters.putAll((Map)instance);
            boolean hasLegacyContentKey = this.parameters.containsKey(LEGACY_CONTENT_MAP_KEY);
            String string = this.parameters.containsKey("source-content") ? (String)this.parameters.get("source-content") : (content = hasLegacyContentKey ? (String)this.parameters.get(LEGACY_CONTENT_MAP_KEY) : null);
            if (content != null && !hasLegacyContentKey && !this.parameters.containsKey("source-is-template")) {
                this.parameters.put("source-is-template", true);
            }
            if (content instanceof Map) {
                content = SnippetExtractor.getInstance().toString((Map)((Object)content), false);
            }
            if (content != null) {
                sourceContent = new StringReader(content.toString());
            }
        } else if (instance instanceof Reader) {
            sourceContent = (Reader)instance;
        }
        if (sourceContent == null) {
            sourceContent = new StringReader(instance.toString());
        }
        try {
            IOUtil.copy((Reader)sourceContent, (Writer)writer);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            sourceContent.close();
            throw throwable;
        }
        sourceContent.close();
    }

    Object instantiateClass(File basePath, Map requestParameter) {
        try {
            try {
                return this.cls.getConstructor(File.class, Map.class).newInstance(basePath, requestParameter);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    return this.cls.getConstructor(Map.class).newInstance(requestParameter);
                }
                catch (NoSuchMethodException ignored1) {
                    try {
                        return this.cls.getConstructor(File.class).newInstance(basePath);
                    }
                    catch (NoSuchMethodException ignored2) {
                        return this.cls.newInstance();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an instance of the configured sourceClass '" + this.cls + '\'', e);
        }
    }
}

