/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.tinyjee.maven.dim.sources.AbstractStreamingSnippetSelector;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularExpressionSnippetSelector
extends AbstractStreamingSnippetSelector {
    public RegularExpressionSnippetSelector() {
        this("re:");
    }

    protected RegularExpressionSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    protected Pattern compile(String expression, boolean caseSensitive) {
        try {
            String regex = this.stripPrefix(expression);
            return caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 66);
        }
        catch (RuntimeException e) {
            Globals.getLog().error((CharSequence)("Failed to parse regular expression pattern '" + expression + '\''), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        Object rawCaseSensitive = macroParameters.get("case-sensitive");
        boolean caseSensitive = rawCaseSensitive == null || Boolean.parseBoolean(String.valueOf(rawCaseSensitive));
        return new AbstractStreamingSnippetSelector.AbstractStreamIterator<Pattern>(this.compile(expression, caseSensitive), content){

            @Override
            protected boolean isCapturingLine(boolean alreadyCapturing, Pattern expression, String line, int lineNumber) {
                return expression.matcher(line).find();
            }
        };
    }
}

