/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.tinyjee.maven.dim.spi.Source;

public class MergeSource
implements Source {
    final Source mainSource;
    final Source paramsSource;
    Source.Content content;

    public MergeSource(Source mainSource, Source paramsSource) {
        this.paramsSource = paramsSource;
        this.mainSource = mainSource;
    }

    public URL getUrl() {
        URL u = this.mainSource.getUrl();
        return u == null ? this.paramsSource.getUrl() : u;
    }

    public Source.Content getContent() {
        if (this.content == null) {
            this.content = new MergeContent(this.mainSource.getContent(), this.paramsSource.getContent());
        }
        return this.content;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergeContent
    implements Source.Content {
        final Source.Content mainContent;
        final Source.Content paramsContent;

        MergeContent(Source.Content mainContent, Source.Content paramsContent) {
            this.mainContent = mainContent;
            this.paramsContent = paramsContent;
        }

        @Override
        public Map<String, Object> getParameters() {
            HashMap<String, Object> merged = new HashMap<String, Object>();
            Map<String, Object> p = this.mainContent.getParameters();
            if (p != null) {
                merged.putAll(p);
            }
            if ((p = this.paramsContent.getParameters()) != null) {
                merged.putAll(p);
            }
            return merged;
        }

        @Override
        public Reader openReader() throws IOException {
            return this.mainContent.openReader();
        }
    }
}

