/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.sources.AbstractSnippetSelector;
import org.tinyjee.maven.dim.utils.CompositeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineRangeSnippetSelector
extends AbstractSnippetSelector {
    public LineRangeSnippetSelector() {
        this("lines:");
    }

    protected LineRangeSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        expression = this.stripPrefix(expression).trim();
        int totalLines = -1;
        ArrayList<IntegerIterator> iterators = new ArrayList<IntegerIterator>();
        for (String rangeExpressions : expression.split("\\s*[,;]+\\s*")) {
            int lastLine;
            int firstLine;
            if (rangeExpressions.endsWith("+")) {
                firstLine = Integer.parseInt(rangeExpressions.substring(0, rangeExpressions.length() - 1));
                lastLine = totalLines == -1 ? this.countTotalLines(content) : totalLines;
            } else if (rangeExpressions.endsWith("-")) {
                firstLine = 1;
                lastLine = Integer.parseInt(rangeExpressions.substring(0, rangeExpressions.length() - 1));
            } else {
                String[] parts = rangeExpressions.split("-");
                if (parts.length > 2 || StringUtils.isEmpty((String)parts[0]) || parts.length == 2 && StringUtils.isEmpty((String)parts[1])) {
                    throw new IllegalArgumentException("The given line number expression is invalid, use either 'START-END' or 'START-', 'START+', e.g. 'lines:25-84', 'lines:100+', 'lines:110-', etc.");
                }
                firstLine = Integer.parseInt(parts[0]);
                lastLine = parts.length == 1 ? firstLine : Integer.parseInt(parts[1]);
            }
            iterators.add(new IntegerIterator(firstLine, lastLine));
        }
        Collections.sort(iterators);
        Iterator iterator = iterators.iterator();
        return new CompositeIterator<Integer>(iterator);
    }

    protected int countTotalLines(LineNumberReader content) throws IOException {
        while (content.readLine() != null) {
        }
        return content.getLineNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIterator
    implements Iterator<Integer>,
    Comparable<IntegerIterator> {
        int lineNumber;
        private final int firstLine;
        private final int lastLine;

        private IntegerIterator(int firstLine, int lastLine) {
            this.firstLine = firstLine;
            this.lastLine = lastLine;
            this.lineNumber = firstLine;
        }

        @Override
        public boolean hasNext() {
            return this.lineNumber <= this.lastLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Integer n = this.lineNumber;
                return n;
            }
            finally {
                ++this.lineNumber;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(IntegerIterator o) {
            return this.firstLine - o.firstLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntegerIterator)) {
                return false;
            }
            IntegerIterator that = (IntegerIterator)o;
            return this.firstLine == that.firstLine && this.lastLine == that.lastLine;
        }

        public int hashCode() {
            int result = this.firstLine;
            result = 31 * result + this.lastLine;
            return result;
        }
    }
}

