/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.tinyjee.maven.dim.sources.AbstractStreamingSnippetSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdSnippetSelector
extends AbstractStreamingSnippetSelector {
    public static final String ID_DELIMITER_CHARS = "\t .,;:=\"'";

    public IdSnippetSelector() {
        this("#");
    }

    protected IdSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public boolean canSelectSnippetsWith(String expression, URL contentUrl, Map<String, Object> macroParameters) {
        return super.canSelectSnippetsWith(expression, contentUrl, macroParameters) || expression.indexOf(32) == -1;
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        return new AbstractStreamingSnippetSelector.AbstractStreamIterator<String>(this.stripPrefix(expression), content){
            boolean previousLineWasStart;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean isCapturingLine(boolean alreadyCapturing, String snippetId, String line, int lineNumber) {
                if ((alreadyCapturing || this.previousLineWasStart) && IdSnippetSelector.this.isEnd(snippetId, line)) {
                    this.previousLineWasStart = false;
                    return false;
                }
                if (!alreadyCapturing) {
                    try {
                        alreadyCapturing = this.previousLineWasStart;
                        Object var6_5 = null;
                        this.previousLineWasStart = IdSnippetSelector.this.isStart(snippetId, line);
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.previousLineWasStart = IdSnippetSelector.this.isStart(snippetId, line);
                        throw throwable;
                    }
                }
                return alreadyCapturing;
            }
        };
    }

    protected boolean isStart(String snippetId, String line) {
        return this.isDemarcator(snippetId, "START", line);
    }

    protected boolean isDemarcator(String snippetId, String what, String line) {
        int snippetIdIndex;
        int idLength = snippetId.length();
        int n = snippetIdIndex = idLength == 0 ? 1 : line.indexOf(snippetId);
        if (snippetIdIndex > 0) {
            boolean isValidSnippetId = idLength == 0 || (line.length() - snippetIdIndex == idLength || ID_DELIMITER_CHARS.indexOf(line.charAt(snippetIdIndex + idLength)) != -1) && ID_DELIMITER_CHARS.indexOf(line.charAt(snippetIdIndex - 1)) != -1;
            String upper = line.toUpperCase(Locale.ENGLISH);
            return isValidSnippetId && upper.contains(what.toUpperCase(Locale.ENGLISH)) && upper.contains("SNIPPET");
        }
        return false;
    }

    protected boolean isEnd(String snippetId, String line) {
        return this.isDemarcator(snippetId, "END", line);
    }
}

