/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinyjee.maven.dim.sources.AbstractStreamingSnippetSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrepLikeSnippetSelector
extends AbstractStreamingSnippetSelector {
    private static final Pattern SNIPPET_END_OFFSET_PATTERN = Pattern.compile("(\\+[0-9]+)$");

    public GrepLikeSnippetSelector() {
        this("grep:");
    }

    protected GrepLikeSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        final boolean caseSensitive = Boolean.parseBoolean(String.valueOf(macroParameters.get("case-sensitive")));
        expression = this.stripPrefix(expression);
        int endOffset = 0;
        Matcher matcher = SNIPPET_END_OFFSET_PATTERN.matcher(expression);
        if (matcher.find()) {
            if (expression.charAt(matcher.start() - 1) == '\\') {
                expression = expression.substring(0, matcher.start() - 1).concat(expression.substring(matcher.start()));
            } else {
                expression = expression.substring(0, matcher.start());
                endOffset = Integer.parseInt(matcher.group(1).substring(1));
            }
        }
        final int addLines = endOffset;
        return new AbstractStreamingSnippetSelector.AbstractStreamIterator<String>(caseSensitive ? expression : expression.toLowerCase(), content){
            int addCount;
            {
                super(x0, x1);
                this.addCount = addLines;
            }

            @Override
            protected boolean isCapturingLine(boolean alreadyCapturing, String expression, String line, int lineNumber) {
                boolean lineIsMatching;
                boolean bl = lineIsMatching = caseSensitive ? line.contains(expression) : line.toLowerCase().contains(expression);
                if (!lineIsMatching && alreadyCapturing && this.addCount > 0) {
                    --this.addCount;
                    return true;
                }
                if (this.addCount == 0) {
                    this.addCount = addLines;
                }
                return lineIsMatching;
            }
        };
    }
}

