/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinyjee.maven.dim.sources.AbstractSnippetSelector;

public abstract class AbstractStreamingSnippetSelector
extends AbstractSnippetSelector {
    protected AbstractStreamingSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractStreamIterator<E>
    implements Iterator<Integer> {
        private final E expression;
        private final LineNumberReader content;
        private String line;
        private boolean eof;
        private boolean capturing;

        protected AbstractStreamIterator(E expression, LineNumberReader content) {
            this.content = content;
            this.expression = expression;
        }

        protected abstract boolean isCapturingLine(boolean var1, E var2, String var3, int var4);

        protected boolean doHasNext() throws IOException {
            while (!this.eof && this.line == null) {
                this.line = this.content.readLine();
                boolean bl = this.eof = this.line == null;
                if (this.eof) continue;
                this.capturing = this.isCapturingLine(this.capturing, this.expression, this.line, this.content.getLineNumber());
                if (this.capturing) continue;
                this.line = null;
            }
            return this.line != null;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.doHasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Integer n = this.content.getLineNumber();
                Object var3_2 = null;
                this.line = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.line = null;
                throw throwable;
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + "expression=" + this.expression + ", content=" + this.content + ", line='" + this.line + '\'' + ", eof=" + this.eof + ", capturing=" + this.capturing + '}';
        }
    }
}

