/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.tinyjee.maven.dim.spi.SnippetSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSnippetSelector
implements SnippetSelector {
    protected final String expressionPrefix;

    protected AbstractSnippetSelector(String expressionPrefix) {
        this.expressionPrefix = expressionPrefix.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String[] getExpressionPrefixes() {
        return new String[]{this.expressionPrefix};
    }

    @Override
    public boolean canSelectSnippetsWith(String expression, URL contentUrl, Map<String, Object> macroParameters) {
        return expression.toLowerCase(Locale.ENGLISH).startsWith(this.expressionPrefix);
    }

    protected void assertExpressionIsValid(String expression, URL contentUrl, Map<String, Object> macroParameters) {
        if (!this.canSelectSnippetsWith(expression, contentUrl, macroParameters)) {
            throw new IllegalStateException("Cannot select snippets for " + contentUrl + " using an expression of '" + expression + '\'');
        }
    }

    protected String stripPrefix(String expression) {
        return expression.toLowerCase(Locale.ENGLISH).startsWith(this.expressionPrefix) ? expression.substring(this.expressionPrefix.length()) : expression;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "expressionPrefix='" + this.expressionPrefix + '\'' + '}';
    }
}

