/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.tinyjee.maven.dim.spi.AbstractSource;
import org.tinyjee.maven.dim.spi.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBufferedSource
extends AbstractSource {
    protected Source.Content content;

    protected AbstractBufferedSource(URL sourceUrl, Map<String, Object> parameters) {
        super(sourceUrl, parameters);
    }

    protected abstract void writeSourceContent(Writer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Source.Content getContent() {
        if (this.content == null) {
            String bufferedContent = null;
            IOException exception = null;
            try {
                StringWriter writer = new StringWriter(2048);
                try {
                    this.writeSourceContent(writer);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    writer.close();
                    throw throwable;
                }
                writer.close();
                bufferedContent = writer.toString();
            }
            catch (IOException e) {
                exception = e;
            }
            this.content = new BufferedSourceContent(bufferedContent, exception);
        }
        return this.content;
    }

    public synchronized void reset() {
        this.content = null;
    }

    protected class BufferedSourceContent
    extends AbstractSource.SourceContent {
        protected final IOException exception;
        protected final String bufferedContent;

        protected BufferedSourceContent(String bufferedContent, IOException exception) {
            super(AbstractBufferedSource.this);
            this.bufferedContent = bufferedContent;
            this.exception = exception;
        }

        public Reader openReader() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return new StringReader(this.bufferedContent);
        }

        public String toString() {
            return "BufferedSourceContent{sourceUrl=" + AbstractBufferedSource.this.sourceUrl + ", parameters=" + AbstractBufferedSource.this.parameters + ", exception=" + this.exception + ", bufferedContent='" + this.bufferedContent + '\'' + '}';
        }
    }
}

