/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sources;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.tinyjee.maven.dim.sources.AbstractSnippetSelector;
import org.tinyjee.maven.dim.sources.TokenAndBraceSnippetSelector;
import org.tinyjee.maven.dim.utils.AbstractSelectableJavaEntitiesList;
import org.tinyjee.maven.dim.utils.JavaClassLoader;
import org.tinyjee.maven.dim.utils.SelectableJavaEntitiesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPLikeSnippetSelector
extends AbstractSnippetSelector {
    public AOPLikeSnippetSelector() {
        this("aj:");
    }

    protected AOPLikeSnippetSelector(String expressionPrefix) {
        super(expressionPrefix);
    }

    @Override
    public Iterator<Integer> selectSnippets(String expression, URL contentUrl, LineNumberReader content, Map<String, Object> macroParameters) throws IOException {
        this.assertExpressionIsValid(expression, contentUrl, macroParameters);
        expression = this.stripPrefix(expression).trim();
        String contentString = this.bufferContent(content);
        boolean expandSnippets = Boolean.parseBoolean(String.valueOf(macroParameters.get("expand-snippets")));
        SelectableJavaEntitiesList<AbstractJavaEntity> all = this.collectJavaEntities(contentUrl, contentString);
        AbstractSelectableJavaEntitiesList<AbstractJavaEntity> matchingEntities = expression.startsWith("@") ? all.selectAnnotated(expression) : all.selectMatching(expression);
        return new LinesIterator(matchingEntities, contentUrl, contentString, expandSnippets);
    }

    protected String bufferContent(LineNumberReader content) throws IOException {
        StringBuilder builder = new StringBuilder(2048);
        String line = content.readLine();
        while (line != null) {
            builder.append(line).append('\n');
            line = content.readLine();
        }
        return builder.toString();
    }

    protected SelectableJavaEntitiesList<AbstractJavaEntity> collectJavaEntities(URL contentUrl, String content) throws IOException {
        JavaSource javaSource = JavaClassLoader.getInstance().addSource(contentUrl, new StringReader(content));
        SelectableJavaEntitiesList<AbstractJavaEntity> allEntities = new SelectableJavaEntitiesList<AbstractJavaEntity>();
        for (JavaClass javaClass : javaSource.getClasses()) {
            this.add(javaClass, allEntities);
        }
        return allEntities;
    }

    protected void add(JavaClass javaClass, SelectableJavaEntitiesList<AbstractJavaEntity> allEntities) {
        allEntities.add((AbstractJavaEntity)javaClass);
        Collections.addAll(allEntities, javaClass.getFields());
        Collections.addAll(allEntities, javaClass.getMethods());
        for (JavaClass nested : javaClass.getNestedClasses()) {
            this.add(nested, allEntities);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LinesIterator
    implements Iterator<Integer> {
        final TokenAndBraceSnippetSelector tokenBraceSelector = new TokenAndBraceSnippetSelector();
        Iterator<Integer> sourceIterator;
        protected final AbstractSelectableJavaEntitiesList<AbstractJavaEntity> matchingEntities;
        protected final URL contentUrl;
        protected final String contentString;
        protected final boolean expandSnippets;

        protected LinesIterator(AbstractSelectableJavaEntitiesList<AbstractJavaEntity> matchingEntities, URL contentUrl, String contentString, boolean expandSnippets) {
            this.matchingEntities = matchingEntities;
            this.contentString = contentString;
            this.expandSnippets = expandSnippets;
            this.contentUrl = contentUrl;
        }

        protected Iterator<Integer> getSourceIterator() {
            if (this.sourceIterator == null) {
                TreeSet<Integer> selectedLines = new TreeSet<Integer>();
                for (AbstractJavaEntity entity : this.matchingEntities) {
                    try {
                        this.selectLines(entity, selectedLines);
                        if (!this.expandSnippets) continue;
                        this.selectBeanProperty(entity, selectedLines);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.sourceIterator = selectedLines.iterator();
            }
            return this.sourceIterator;
        }

        protected void selectLines(AbstractJavaEntity entity, Set<Integer> selectedLines) throws IOException {
            if (entity == null) {
                return;
            }
            int firstLine = entity.getLineNumber();
            if (entity instanceof JavaField) {
                int lines = this.countLines(entity.getCodeBlock());
                for (int i = 0; i < lines; ++i) {
                    selectedLines.add(firstLine + i);
                }
            } else {
                Iterator<Integer> iterator = this.tokenBraceSelector.selectSnippets("tb:[" + firstLine + "]{", this.contentUrl, new LineNumberReader(new StringReader(this.contentString)), Collections.singletonMap("case-sensitive", true));
                while (iterator.hasNext()) {
                    selectedLines.add(iterator.next());
                }
            }
            if (this.expandSnippets && entity.getComment() != null) {
                this.selectCommentAbove(firstLine, selectedLines);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void selectCommentAbove(int firstLine, Set<Integer> selectedLines) throws IOException {
            int lastCommentLineNumber = -1;
            LineNumberReader reader = new LineNumberReader(new StringReader(this.contentString));
            try {
                String line;
                while ((line = reader.readLine()) != null && reader.getLineNumber() < firstLine) {
                    if (!line.trim().startsWith("/*")) continue;
                    lastCommentLineNumber = reader.getLineNumber();
                }
            }
            finally {
                reader.close();
            }
            if (lastCommentLineNumber > -1) {
                for (int i = lastCommentLineNumber; i < firstLine; ++i) {
                    selectedLines.add(i);
                }
            }
        }

        protected int countLines(String text) {
            return new StringTokenizer(text, "\n").countTokens();
        }

        protected void selectBeanProperty(AbstractJavaEntity entity, Set<Integer> selectedLines) throws IOException {
            BeanProperty beanProperty;
            String propertyName = null;
            if (entity instanceof JavaField) {
                propertyName = entity.getName();
            } else if (entity instanceof JavaMethod && ((propertyName = entity.getName()).startsWith("set") || propertyName.startsWith("get")) && propertyName.length() > 3) {
                String string = propertyName = (propertyName = propertyName.substring(3)).length() == 4 ? propertyName.toLowerCase() : Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            }
            if (propertyName != null && (beanProperty = entity.getParentClass().getBeanProperty(propertyName)) != null) {
                this.selectLines((AbstractJavaEntity)beanProperty.getAccessor(), selectedLines);
                this.selectLines((AbstractJavaEntity)beanProperty.getMutator(), selectedLines);
            }
        }

        @Override
        public boolean hasNext() {
            return this.getSourceIterator().hasNext();
        }

        @Override
        public Integer next() {
            return this.getSourceIterator().next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

