/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sh;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class StyleHandler {
    static final String BASE_DIR = "css/";
    static final String BASE_NAME = "shCore";
    static final String LB = System.getProperty("line.separator", "\n");
    static final Charset CSS_CHARSET = Charset.forName("UTF-8");
    static final String SCROLLBARS_PATCH = ".syntaxhighlighter {" + LB + "  overflow: visible !important;" + LB + "  overflow-y: hidden !important;" + LB + "  overflow-x: auto !important;" + LB + '}';
    static final String BORDER_COLOR = System.getProperty("dim.highlighted.border.color", "#e5e5e5");
    static final String BORDER_PATCH = "div.syntaxhighlighter {" + LB + "  border: 1px solid " + BORDER_COLOR + ';' + LB + '}';
    final String themeName;
    final Map<String, byte[]> sources = new HashMap<String, byte[]>();

    public StyleHandler() {
        this(System.getProperty("org.tinyjee.doxia.include.sh.default.theme", "default"));
    }

    public StyleHandler(String themeName) {
        this.themeName = themeName.trim().toLowerCase();
        this.scanSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scanSources() {
        try {
            Class<StyleHandler> cls = StyleHandler.class;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
            InputStream in = cls.getResource("/js-bundle/syntax-highlighter.zip").openStream();
            ZipInputStream zIn = new ZipInputStream(in);
            try {
                this.sources.clear();
                String cssName = this.getCSSFileName();
                ZipEntry ze = zIn.getNextEntry();
                while (ze != null) {
                    String name = ze.getName();
                    if (name.endsWith(".css") && (name = BASE_DIR + new File(name).getName()).equals(cssName)) {
                        buffer.reset();
                        IOUtil.copy((InputStream)zIn, (OutputStream)buffer);
                        this.sources.put(name, buffer.toByteArray());
                    }
                    ze = zIn.getNextEntry();
                }
            }
            finally {
                zIn.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCSSFileName() {
        return "css/shCore" + Character.toUpperCase(this.themeName.charAt(0)) + this.themeName.substring(1) + ".css";
    }

    public boolean isHandlingStyleForTheme(String theme) {
        return this.themeName.equalsIgnoreCase(theme);
    }

    public String getCSSContent(String cssName) {
        if (cssName == null) {
            cssName = this.getCSSFileName();
        }
        CharBuffer buffer = CSS_CHARSET.decode(ByteBuffer.wrap(this.sources.get(cssName)));
        StringBuilder builder = new StringBuilder(buffer.length() + 128).append(buffer);
        builder.append(LB).append(SCROLLBARS_PATCH).append(LB);
        if (StringUtils.isNotEmpty((String)BORDER_COLOR)) {
            builder.append(LB).append(BORDER_PATCH).append(LB);
        }
        return builder.toString();
    }
}

