/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sh;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.sh.BrushResolver;
import org.tinyjee.maven.dim.sh.HighlighterThreadLocal;
import org.tinyjee.maven.dim.sh.StyleHandler;
import org.tinyjee.maven.dim.spi.FixedContentSource;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.SnippetExtractor;
import org.tinyjee.maven.dim.utils.XhtmlEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeHighlighter {
    static final String LB = System.getProperty("line.separator", "\n");
    static final HighlighterThreadLocal highlighters = new HighlighterThreadLocal();
    StyleHandler styleHandler = new StyleHandler();
    static final String HTML_OPEN_TAG = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" " + LB + "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> " + LB + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"> " + LB;
    static final String HTML_CLOSE_TAG = "</html>";
    final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public String highlight(String brushName, String sourceContent, Map<String, String> params) {
        return highlighters.getHighlighter().highlightToHTML(brushName, sourceContent, params);
    }

    public String highlight(Map<Integer, List<String>> sourceLines, int firstLine, String brushName, Map<String, String> params) {
        LinkedList<String> lines = new LinkedList<String>();
        LinkedList<Integer> linesToRemove = new LinkedList<Integer>();
        int lineNumber = -1;
        int delta = 0;
        for (Map.Entry<Integer, List<String>> entry : sourceLines.entrySet()) {
            if (lines.isEmpty()) {
                delta = firstLine == -1 ? 0 : entry.getKey() - firstLine;
                params.put("first-line", String.valueOf(entry.getKey() - delta));
            } else {
                int len = entry.getKey();
                for (int i = lineNumber; i < len; ++i) {
                    linesToRemove.add(i - delta);
                    lines.add("");
                }
            }
            lineNumber = entry.getKey() + entry.getValue().size();
            lines.addAll((Collection<String>)entry.getValue());
        }
        String code = SnippetExtractor.getInstance().toString(lines);
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        String htmlResult = this.highlight(brushName, code, params);
        if (!linesToRemove.isEmpty()) {
            htmlResult = this.removeLines(htmlResult, linesToRemove);
        }
        return htmlResult;
    }

    public boolean attachStylesheet(Sink sink, Map requestParameters) throws IOException {
        String highlightTheme = (String)requestParameters.get("highlight-theme");
        if (highlightTheme != null && !this.styleHandler.isHandlingStyleForTheme(highlightTheme)) {
            this.styleHandler = new StyleHandler(highlightTheme);
        }
        String cssFileName = this.styleHandler.getCSSFileName();
        return Globals.getInstance().operateOnSink(sink).attachCss(cssFileName, this.styleHandler.getCSSContent(cssFileName));
    }

    public void execute(URL source, Map requestParameters, Map<Integer, List<String>> sourceLines, Sink sink) throws IOException {
        if (source == null) {
            source = FixedContentSource.UNKNOWN;
        }
        Map<String, String> params = this.buildHighlighterParams(source, sourceLines, requestParameters);
        String brushName = this.findBrushName(source, sourceLines, requestParameters);
        int firstLine = requestParameters.containsKey("set-first-line") ? Integer.parseInt((String)requestParameters.get("set-first-line")) : -1;
        String htmlResult = this.highlight(sourceLines, firstLine, brushName, params);
        if (htmlResult == null) {
            Globals.getLog().error((CharSequence)("No content to highlight for source '" + source + "' with params '" + params + '\''));
            return;
        }
        if (Globals.getInstance().operateOnSink(sink).isHTMLCapableSink() && this.attachStylesheet(sink, requestParameters)) {
            sink.rawText(htmlResult);
        } else {
            sink.verbatim(SinkEventAttributeSet.BOXED);
            sink.text("TODO: Image Rendering !!");
            sink.verbatim_();
        }
    }

    public String findBrushName(URL source, Map<Integer, List<String>> sourceLines, Map requestParameters) {
        String brushName;
        int idx;
        if (source == null) {
            source = FixedContentSource.UNKNOWN;
        }
        return (idx = (brushName = this.findBrushAlias(source, sourceLines, requestParameters)).indexOf(47)) == -1 ? brushName : brushName.substring(idx + 1);
    }

    protected String findBrushAlias(URL source, Map<Integer, List<String>> sourceLines, Map requestParameters) {
        String brushAlias;
        block1: {
            BrushResolver resolver;
            String string = brushAlias = requestParameters == null ? null : (String)requestParameters.get("highlight-type");
            if (brushAlias != null) break block1;
            Iterator<BrushResolver> i$ = highlighters.getHighlighter().getBrushResolvers().iterator();
            while (i$.hasNext() && (brushAlias = (resolver = i$.next()).detectBrushAlias(source, sourceLines)) == null) {
            }
        }
        return brushAlias == null ? "plain" : brushAlias;
    }

    protected boolean isCodeSurroundedByHTML(URL source, Map<Integer, List<String>> sourceLines, Map requestParameters) {
        return this.findBrushAlias(source, sourceLines, requestParameters).startsWith("html/");
    }

    public Map<String, String> buildHighlighterParams(URL source, Map<Integer, List<String>> sourceLines, Map requestParameters) {
        Object highlightLines;
        Object padLineNumbers;
        if (source == null) {
            source = FixedContentSource.UNKNOWN;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("html-script", String.valueOf(this.isCodeSurroundedByHTML(source, sourceLines, requestParameters)));
        params.put("gutter", System.getProperty("org.tinyjee.maven.dim.defaultShowGutter", "true"));
        if ("false".equalsIgnoreCase(String.valueOf(requestParameters.get("show-gutter")).trim())) {
            params.put("gutter", "false");
        }
        if ((padLineNumbers = requestParameters.get("pad-line-numbers")) != null) {
            params.put("pad-line-numbers", Integer.valueOf(padLineNumbers.toString()).toString());
        }
        if ((highlightLines = requestParameters.get("highlight")) != null) {
            String[] lines;
            StringBuilder buffer = new StringBuilder().append("[0");
            for (String lineNumber : lines = highlightLines.toString().split("\\s*[,;+]\\s*")) {
                String[] parts = lineNumber.split("\\s*-\\s*");
                if (parts.length == 1) {
                    buffer.append(", ").append(Integer.parseInt(parts[0]));
                    continue;
                }
                if (parts.length != 2 || !StringUtils.isNotEmpty((String)parts[0])) continue;
                int len = Integer.parseInt(parts[1]);
                for (int i = Integer.parseInt(parts[0]); i <= len; ++i) {
                    buffer.append(", ").append(i);
                }
            }
            params.put("highlight", buffer.append(']').toString());
        }
        if ((highlightLines = requestParameters.get("highlight-lines")) != null && sourceLines != null) {
            SortedSet<Integer> selectedLines;
            HashMap<String, Object> parameters = new HashMap<String, Object>(requestParameters);
            parameters.put("snippet", highlightLines);
            try {
                SnippetExtractor extractor = SnippetExtractor.getInstance();
                selectedLines = extractor.findSelectedLines(new FixedContentSource(extractor.toString(sourceLines, true), parameters)).get(0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StringBuilder buffer = new StringBuilder().append("[0");
            for (Integer selectedLine : selectedLines) {
                buffer.append(',').append(selectedLine);
            }
            params.put("highlight", buffer.append(']').toString());
        }
        for (Map.Entry entry : requestParameters.entrySet()) {
            Map.Entry e = entry;
            String key = String.valueOf(e.getKey());
            if (!key.startsWith("sh-")) continue;
            params.put(key.substring(3), (String)e.getValue());
        }
        return params;
    }

    protected String removeLines(String content, Collection<Integer> linesToRemove) {
        try {
            HashSet<String> classesToRemove = new HashSet<String>(linesToRemove.size());
            for (Integer integer : linesToRemove) {
                classesToRemove.add("number" + integer);
            }
            content = HTML_OPEN_TAG + content + HTML_CLOSE_TAG;
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            builder.setEntityResolver(new XhtmlEntityResolver());
            Document document = builder.parse(new InputSource(new StringReader(content)));
            NodeList divs = document.getDocumentElement().getElementsByTagName("div");
            for (int i = divs.getLength() - 1; i >= 0; --i) {
                Element div = (Element)divs.item(i);
                for (String className : div.getAttribute("class").split("\\s+")) {
                    if (!classesToRemove.contains(className)) continue;
                    div.getParentNode().removeChild(div);
                }
            }
            StringWriter buffer = new StringWriter(content.length());
            this.transformerFactory.newTransformer().transform(new DOMSource(document), new StreamResult(buffer));
            content = buffer.toString();
            content = content.substring(content.indexOf(60, content.indexOf("<html") + 5), content.lastIndexOf(HTML_CLOSE_TAG));
        }
        catch (Exception e) {
            Log log = Globals.getLog();
            log.error((CharSequence)"Failed to remove hidden lines from highlighted content. The result may contain content that should have been hidden.", (Throwable)e);
            log.error((CharSequence)content);
        }
        return content;
    }
}

