/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.sh;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.tinyjee.maven.dim.sh.BrushResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledBrushesResolver
implements BrushResolver {
    static final Properties typeMapping = new Properties();

    @Override
    public Collection<URL> resolveBrushes() {
        Class<BundledBrushesResolver> cls = BundledBrushesResolver.class;
        return Arrays.asList(cls.getResource("/js-bundle/syntax-highlighter-default-brushes.zip"), cls.getResource("/js-bundle/shBatchBrush.js"), cls.getResource("/js-bundle/shClojureBrush.js"), cls.getResource("/js-bundle/shVelocityBrush.js"), cls.getResource("/js-bundle/shJavaPropertiesBrush.js"));
    }

    @Override
    public String detectBrushAlias(URL source, Map<Integer, List<String>> sourceContent) {
        String aliasByExtension;
        String aliasByContent = this.detectAliasByContent(sourceContent);
        String string = aliasByExtension = source == null ? null : this.detectAliasByExtension(source.getFile());
        if (aliasByExtension != null && (aliasByContent == null || aliasByExtension.startsWith("html/") && !aliasByContent.startsWith("html/"))) {
            return aliasByExtension;
        }
        return aliasByContent;
    }

    protected Properties getTypeMappingProperties() {
        return typeMapping;
    }

    protected String detectAliasByExtension(String file) {
        if (file == null) {
            return null;
        }
        int extensionIndex = file.indexOf(46);
        while (extensionIndex != -1) {
            String extension = file.substring(extensionIndex);
            if (extension.length() > 1) {
                extension = extension.toLowerCase(Locale.ENGLISH);
                String typeMapping = this.getTypeMappingProperties().getProperty(extension);
                if (typeMapping != null) {
                    return typeMapping;
                }
            }
            extensionIndex = file.indexOf(46, extensionIndex + 1);
        }
        return null;
    }

    protected String detectAliasByContent(Map<Integer, List<String>> content) {
        String firstLine = "";
        if (content != null && !content.isEmpty()) {
            List<String> lines = content.values().iterator().next();
            for (String line : lines) {
                if (line == null || line.trim().length() == 0) continue;
                firstLine = line;
                break;
            }
        }
        for (Map.Entry<Object, Object> entry : this.getTypeMappingProperties().entrySet()) {
            boolean isRegExpMatch;
            String key = entry.getKey().toString();
            if (!key.startsWith("^")) continue;
            boolean bl = isRegExpMatch = key.startsWith("^RegExp") && Pattern.compile(key.substring(7)).matcher(firstLine).matches();
            if (!isRegExpMatch && !firstLine.startsWith(key.substring(1))) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    static {
        try {
            Class<BundledBrushesResolver> cls = BundledBrushesResolver.class;
            typeMapping.load(cls.getResourceAsStream("/org/tinyjee/maven/dim/sh/type-to-brush.mapping.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

