/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.utils.AbstractAliasHandler;
import org.tinyjee.maven.dim.utils.AbstractPositioningDocumentBuilder;
import org.tinyjee.maven.dim.utils.JaxbXmlSerializer;
import org.tinyjee.maven.dim.utils.NodeListAdapter;
import org.tinyjee.maven.dim.utils.PositioningDocumentBuilder;
import org.tinyjee.maven.dim.utils.PositioningJsonDocumentBuilder;
import org.tinyjee.maven.dim.utils.XPathEvaluatorImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLoader
extends HashMap<String, Object> {
    private static final long serialVersionUID = -3702740619423786753L;
    private static final String LOCAL_ONLY = "local-only";
    public static final String PARAM_ALIAS = "source-xml";
    public static final String PARAM_XML = "xml";
    public static final String PARAM_XML_CLASS = "xml-class";
    public static final String PARAM_JSON = "json";
    public static final String PARAM_XSL = "xsl";
    public static final String PARAM_ADD_XSL = "add-xsl";
    public static final String PARAM_ADD_DECLARATION = "add-declaration";
    public static final String PARAM_LOAD_SCHEMA = "load-schema";
    public static final String PARAM_INDENT = "indent";
    public static final String PARAM_NAMESPACE_AWARE = "namespace-aware";
    public static final String OUT_PARAM_DOCUMENT = "document";
    public static final String OUT_PARAM_ORIGINAL_DOCUMENT = "originalDocument";
    public static final String OUT_PARAM_SCHEMA_MAP = "schemaMap";
    public static final String OUT_PARAM_XPATH = "xpath";
    public static final String OUT_PARAM_ORIGINAL_XPATH = "originalXpath";
    final transient TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public XmlLoader(File baseDir, Map<String, Object> requestParams) throws Exception {
        Document document;
        LinkedHashMap<String, Document> schemaMap;
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        this.putAll(requestParams);
        if (this.containsKey(PARAM_XML_CLASS)) {
            this.put(PARAM_XML, "class:" + this.get(PARAM_XML_CLASS));
        }
        String sourcePath = (String)this.get(this.containsKey(PARAM_JSON) ? PARAM_JSON : PARAM_XML);
        Object rawNamespaceAware = this.containsKey(PARAM_NAMESPACE_AWARE) ? this.get(PARAM_NAMESPACE_AWARE) : Boolean.valueOf(this.containsKey(PARAM_XSL));
        boolean namespaceAware = Boolean.parseBoolean(String.valueOf(rawNamespaceAware));
        LinkedHashMap<String, Document> linkedHashMap = schemaMap = this.containsKey(PARAM_LOAD_SCHEMA) && !"false".equalsIgnoreCase(String.valueOf(this.get(PARAM_LOAD_SCHEMA))) ? new LinkedHashMap<String, Document>() : null;
        Document originalDocument = document = sourcePath.startsWith("class:") ? this.buildDocument(baseDir, sourcePath.substring(6), schemaMap) : this.readDocument(baseDir, sourcePath, this.containsKey(PARAM_JSON) || sourcePath.endsWith(".json"), namespaceAware);
        this.put("document-uri", document.getDocumentURI());
        if (this.containsKey(PARAM_XSL)) {
            document = this.transformDocument(baseDir, document);
        }
        if (this.containsKey(PARAM_ADD_XSL)) {
            ProcessingInstruction pi = document.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this.get(PARAM_ADD_XSL) + '\"');
            document.insertBefore(pi, document.getDocumentElement());
        }
        this.put(OUT_PARAM_DOCUMENT, document);
        XPathEvaluatorImplementation documentXpathEvaluator = new XPathEvaluatorImplementation(document);
        this.put(OUT_PARAM_XPATH, documentXpathEvaluator);
        this.put(OUT_PARAM_ORIGINAL_DOCUMENT, originalDocument);
        this.put(OUT_PARAM_ORIGINAL_XPATH, new XPathEvaluatorImplementation(originalDocument));
        this.put(OUT_PARAM_SCHEMA_MAP, schemaMap);
        if (schemaMap != null) {
            if (debug) {
                log.debug((CharSequence)"About to load all referenced xml schema documents.");
            }
            this.loadSchema(document, schemaMap);
        }
        if (debug) {
            if (document != originalDocument) {
                log.debug((CharSequence)("Original Document:\n" + XPathEvaluatorImplementation.serializeNode(originalDocument, true, true)));
                log.debug((CharSequence)("Transformed Document:\n" + XPathEvaluatorImplementation.serializeNode(document, true, true)));
            } else {
                log.debug((CharSequence)("Document:\n" + XPathEvaluatorImplementation.serializeNode(document, true, true)));
            }
        }
        if (!this.containsKey("source")) {
            if (!this.containsKey("highlight-type")) {
                this.put("highlight-type", PARAM_XML);
            }
            if (!this.containsKey("source-content-type")) {
                this.put("source-content-type", PARAM_XML);
            }
            if (debug) {
                log.debug((CharSequence)("Did not find any 'source', assuming the loaded XML document is the content to include. (verbatim=" + this.get("verbatim") + ", " + "highlight-type" + '=' + this.get("highlight-type") + ", " + "source-content-type" + '=' + this.get("source-content-type") + ')'));
            }
            this.put("content", XPathEvaluatorImplementation.serializeNode(document, !Boolean.parseBoolean(String.valueOf(this.get(PARAM_ADD_DECLARATION))), true));
        }
    }

    Document transformDocument(File baseDir, Document document) throws Exception {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        if (!this.containsKey("verbatim")) {
            this.put("verbatim", false);
        }
        URL xslURL = ResourceResolver.findSource(baseDir, (String)this.get(PARAM_XSL));
        if (debug) {
            log.debug((CharSequence)("About to transform previously loaded XML content using XSL " + xslURL));
        }
        Transformer transformer = this.transformerFactory.newTransformer(new StreamSource(xslURL.openStream(), xslURL.toString()));
        try {
            for (Map.Entry entry : this.entrySet()) {
                if (entry.getValue() == null) continue;
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
            document = this.sourceToDocument(transformer, (Source)new DOMSource(document));
        }
        catch (TransformerException e) {
            log.error((CharSequence)("Failed transforming document '" + document.getDocumentURI() + "' using XSL '" + xslURL + "'. " + "Run with -X to see the content that failed."), (Throwable)e);
            if (debug) {
                log.debug((CharSequence)("Document that failed:\n" + XPathEvaluatorImplementation.serializeNode(document, true, true)));
            }
            throw e;
        }
        return this.beautifyDocument(document, false);
    }

    Document readDocument(File baseDir, String sourcePath, boolean sourceIsJson, boolean namespaceAware) throws Exception {
        Log log = Globals.getLog();
        URL xmlURL = ResourceResolver.findSource(baseDir, sourcePath);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("About to create XML content (namespaceAware=" + namespaceAware + ") from " + (sourceIsJson ? "JSON" : "XML") + " encoded in " + xmlURL));
        }
        AbstractPositioningDocumentBuilder documentBuilder = sourceIsJson ? new PositioningJsonDocumentBuilder() : new PositioningDocumentBuilder(namespaceAware);
        return this.beautifyDocument(documentBuilder.parse(xmlURL), false);
    }

    Document buildDocument(File baseDir, String classExpression, Map<String, Document> schemaMap) throws Exception {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        int braceIndex = classExpression.indexOf(40);
        String className = braceIndex != -1 ? classExpression.substring(0, classExpression.lastIndexOf(46, braceIndex)) : classExpression;
        if (debug) {
            log.debug((CharSequence)("About to create XML content from class '" + className + '\''));
        }
        Object xmlInstance = null;
        Class<?> xmlClass = null;
        try {
            xmlClass = ResourceResolver.resolveClass(baseDir, className);
            if (className.equals(classExpression)) {
                xmlInstance = xmlClass.newInstance();
            } else {
                String[] methods;
                for (String methodName : methods = classExpression.substring(className.length() + 1).split("\\)\\.")) {
                    Method method;
                    if (debug) {
                        log.debug((CharSequence)("Attempting to look for public method '" + methodName + "' in class '" + className + '\''));
                    }
                    xmlInstance = method.invoke(Modifier.isStatic((method = xmlClass.getMethod(methodName.substring(0, methodName.indexOf(40)), new Class[0])).getModifiers()) ? null : xmlInstance, new Object[0]);
                    xmlClass = xmlInstance.getClass();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.instanceToDocument(xmlClass, xmlInstance, schemaMap);
    }

    void loadSchema(Document document, Map<String, Document> schemaMap) throws Exception {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        boolean localOnly = LOCAL_ONLY.equalsIgnoreCase(String.valueOf(this.get(PARAM_LOAD_SCHEMA)));
        for (Node node : new NodeListAdapter(document.getElementsByTagName("*"))) {
            Object[] locations;
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null) continue;
            ArrayList<Object> systemIds = null;
            Node schemaLocation = attributes.getNamedItem("xsi:schemaLocation");
            if (schemaLocation == null) {
                schemaLocation = attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            }
            if (schemaLocation != null) {
                locations = schemaLocation.getNodeValue().split("\\s+");
                if (locations.length % 2 != 0) {
                    throw new IllegalArgumentException("Cannot load xml schemata, the location(s) " + Arrays.toString(locations) + " specified in element '<" + node.getNodeName() + "/>' are not formatted as expected, " + " 'namespace systemId nextNamespace nextSystemId..'");
                }
                systemIds = new ArrayList<Object>(locations.length / 2);
                for (int i = 1; i < locations.length; i += 2) {
                    systemIds.add(locations[i]);
                }
            }
            if ((schemaLocation = attributes.getNamedItem("xsi:noNamespaceSchemaLocation")) != null) {
                locations = schemaLocation.getNodeValue().split("\\s+");
                if (systemIds == null) {
                    systemIds = new ArrayList(locations.length);
                }
                Collections.addAll(systemIds, locations);
            }
            if (systemIds == null) continue;
            Transformer transformer = this.transformerFactory.newTransformer();
            for (String string : systemIds) {
                String documentURI;
                URI schemaUri;
                if (schemaMap.containsKey(string)) {
                    if (!debug) continue;
                    log.debug((CharSequence)("Not loading schema '" + string + "' as it was already loaded."));
                    continue;
                }
                if (debug) {
                    log.debug((CharSequence)("About to lookup schema '" + string + '\''));
                }
                URI uRI = schemaUri = (documentURI = document.getDocumentURI()) == null ? URI.create(string) : URI.create(documentURI).resolve(string);
                if (localOnly && String.valueOf(schemaUri.getScheme()).toLowerCase(Locale.ENGLISH).startsWith("http")) continue;
                String string2 = schemaUri.toASCIIString();
                if (debug) {
                    log.debug((CharSequence)("Loading schema '" + string2 + '\''));
                }
                schemaMap.put(string2, this.beautifyDocument(this.sourceToDocument(transformer, (Source)new StreamSource(string2)), false));
            }
        }
    }

    boolean requiresBeautification() {
        return Boolean.parseBoolean(String.valueOf(this.get(PARAM_INDENT)));
    }

    Document beautifyDocument(Document document, boolean force) throws Exception {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        if (!force && !this.requiresBeautification()) {
            if (debug) {
                log.debug((CharSequence)("XML beautification not required, returning original document " + document.getDocumentURI() + '.'));
            }
            return document;
        }
        if (debug) {
            log.debug((CharSequence)("Beautifying document " + document.getDocumentURI() + '.'));
        }
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty(PARAM_INDENT, "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        transformer.transform(new DOMSource(document), new StreamResult(buffer));
        return this.sourceToDocument(transformer, (Source)new StreamSource(new ByteArrayInputStream(buffer.toByteArray()), document.getDocumentURI()));
    }

    Document sourceToDocument(String systemId, Source source) throws Exception {
        source.setSystemId(systemId);
        return this.sourceToDocument(this.transformerFactory.newTransformer(), source);
    }

    Document sourceToDocument(Transformer transformer, Source source) throws Exception {
        DOMResult domResult = new DOMResult(null, source.getSystemId());
        transformer.transform(source, domResult);
        Document document = (Document)domResult.getNode();
        document.setDocumentURI(source.getSystemId());
        return document;
    }

    Document instanceToDocument(Class<?> xmlClass, Object xmlInstance, Map<String, Document> schemaMap) throws Exception {
        Document document;
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        String className = xmlClass.getName();
        if (xmlInstance instanceof Document) {
            if (debug) {
                log.debug((CharSequence)"Found that class is an instance of 'Document', using it directly");
            }
            document = (Document)xmlInstance;
        } else if (xmlInstance instanceof Source) {
            if (debug) {
                log.debug((CharSequence)"Found that class is an instance of 'javax.xml.transform.Source', transforming it to a 'Document'.");
            }
            document = this.sourceToDocument(className, (Source)xmlInstance);
        } else if (xmlClass.isAnnotationPresent(XmlRootElement.class)) {
            if (debug) {
                log.debug((CharSequence)"Found that class is an annotated with 'XmlRootElement', transforming it to a 'Document'.");
            }
            JaxbXmlSerializer serializer = new JaxbXmlSerializer(xmlClass);
            document = serializer.serialize(xmlInstance, schemaMap != null);
            if (schemaMap != null) {
                for (Map.Entry<String, Document> entry : serializer.generateSchema().entrySet()) {
                    schemaMap.put(entry.getKey(), this.beautifyDocument(entry.getValue(), true));
                }
            }
        } else {
            if (debug) {
                log.debug((CharSequence)"Did not find any supported XML type, using Bean encoding to transform it to a 'Document'.");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(buffer);
            encoder.writeObject(xmlInstance);
            encoder.close();
            document = this.sourceToDocument(className, (Source)new StreamSource(new ByteArrayInputStream(buffer.toByteArray())));
        }
        if (document.getDocumentURI() == null) {
            String documentURI = xmlClass.getSimpleName().replaceAll("(?!^)([A-Z]+)", "-$1").toLowerCase() + ".xml";
            if (debug) {
                log.debug((CharSequence)("The generated document contained no document URI, using '" + documentURI + "' instead."));
            }
            document.setDocumentURI(documentURI);
        }
        return this.beautifyDocument(document, true);
    }

    public static class AliasHandler
    extends AbstractAliasHandler {
        public AliasHandler() {
            super(XmlLoader.PARAM_ALIAS, XmlLoader.PARAM_XML, XmlLoader.class.getName());
        }
    }
}

