/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.spi.UrlFetcher;
import org.tinyjee.maven.dim.utils.AbstractAliasHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptInvoker
extends HashMap<String, Object> {
    private static final long serialVersionUID = 8955658194210732920L;
    private static final Pattern EVAL_PREFIX_PATTERN = Pattern.compile("^eval\\[([^\\[\\]\\s]+)\\]:(.+)$");
    public static final String PARAM_ALIAS = "source-script";
    public static final String PARAM_SCRIPT = "script";
    private static ScriptExecutor executor;

    private static synchronized ScriptExecutor getExecutor() {
        if (executor == null) {
            try {
                String executorClass = System.getProperty("dim.script.invoker.engine.class", "org.tinyjee.maven.dim.extensions.ScriptExecutorJSR223");
                executor = (ScriptExecutor)Class.forName(executorClass).newInstance();
            }
            catch (Throwable e) {
                StringWriter buffer = new StringWriter();
                e.printStackTrace(new PrintWriter(buffer));
                final String errorMessage = e.toString();
                final String stackTrace = buffer.toString();
                executor = new ScriptExecutor(){

                    @Override
                    public void execute(Map<String, Object> context, String scriptExtension, String scriptContent, String scriptName) throws Exception {
                        Log log = Globals.getLog();
                        log.error((CharSequence)("Failed executing script '" + scriptName + "':\n----\n" + scriptContent + "\n----\n, " + "caused by: " + errorMessage + "\n" + stackTrace));
                        context.put("source-content", "Failed executing script '" + scriptName + "', caused by: " + errorMessage);
                    }
                };
            }
        }
        return executor;
    }

    public ScriptInvoker(File baseDir, Map<String, Object> requestParams) throws Exception {
        String scriptName;
        String scriptContent;
        String scriptExtension;
        this.putAll(requestParams);
        String script = (String)this.get(PARAM_SCRIPT);
        if (script == null) {
            throw new IllegalArgumentException("No script (parameter 'script') was defined.");
        }
        Matcher evalMatcher = EVAL_PREFIX_PATTERN.matcher(script);
        if (evalMatcher.matches()) {
            scriptExtension = evalMatcher.group(1);
            scriptContent = evalMatcher.group(2);
            scriptName = baseDir + File.separator + "local." + scriptExtension;
        } else {
            URL scriptURL = ResourceResolver.findSource(baseDir, script);
            scriptContent = UrlFetcher.readerToString(UrlFetcher.getReadableSource(scriptURL), true);
            scriptName = "file".equals(scriptURL.getProtocol()) ? new File(scriptURL.toURI()).toString() : scriptURL.toString();
            scriptExtension = FileUtils.extension((String)scriptName);
        }
        this.put("globals", Globals.getInstance());
        this.put("scriptName", scriptName);
        ScriptInvoker.getExecutor().execute(this, scriptExtension, scriptContent, scriptName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ScriptExecutor {
        public void execute(Map<String, Object> var1, String var2, String var3, String var4) throws Exception;
    }

    public static class AliasHandler
    extends AbstractAliasHandler {
        public AliasHandler() {
            super(ScriptInvoker.PARAM_ALIAS, ScriptInvoker.PARAM_SCRIPT, ScriptInvoker.class.getName());
        }
    }
}

