/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.utils.AbstractAliasHandler;
import org.tinyjee.maven.dim.utils.SelectableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesLoader
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 7451224247313497738L;
    public static final String PARAM_ALIAS = "source-properties";
    public static final String PARAM_PROPERTIES = "properties";
    public static final String OUT_PARAM_LOADED_PROPERTIES = "loadedProperties";
    public static final String OUT_PARAM_LOADED_PROPERTY_KEYS = "loadedPropertyKeys";

    public PropertiesLoader(File baseDir, Map<String, Object> requestParams) {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        this.putAll(requestParams);
        URL propertiesURL = ResourceResolver.findSource(baseDir, (String)requestParams.get(PARAM_PROPERTIES));
        try {
            Properties properties = new Properties();
            boolean isXml = "xml".equalsIgnoreCase(FileUtils.extension((String)propertiesURL.getFile()));
            if (debug) {
                log.debug((CharSequence)("About to load properties from '" + propertiesURL + "'. Used format: " + (isXml ? "xml" : PARAM_PROPERTIES)));
            }
            if (isXml) {
                properties.loadFromXML(propertiesURL.openStream());
            } else {
                properties.load(propertiesURL.openStream());
            }
            this.put(OUT_PARAM_LOADED_PROPERTIES, properties);
            SelectableArrayList<Object> sortedKeys = new SelectableArrayList<Object>(new TreeSet<Object>(properties.keySet()));
            this.put(OUT_PARAM_LOADED_PROPERTY_KEYS, sortedKeys);
            if (debug) {
                log.debug((CharSequence)"Loaded properties:");
            }
            for (Object e : sortedKeys) {
                String propertyKey = e.toString();
                String propertyValue = properties.getProperty(propertyKey);
                this.put(propertyKey, propertyValue);
                if (!debug) continue;
                log.debug((CharSequence)(propertyKey + "=" + propertyValue));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AliasHandler
    extends AbstractAliasHandler {
        public AliasHandler() {
            super(PropertiesLoader.PARAM_ALIAS, PropertiesLoader.PARAM_PROPERTIES, PropertiesLoader.class.getName());
        }
    }
}

