/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.tinyjee.maven.dim.extensions.JavaDocTagsHandler;
import org.tinyjee.maven.dim.extensions.SelectableMappedJavaEntitiesList;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.utils.AbstractAliasHandler;
import org.tinyjee.maven.dim.utils.JavaClassLoader;
import org.tinyjee.maven.dim.utils.PrintableMap;
import org.tinyjee.maven.dim.utils.SelectableJavaEntitiesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSourceLoader
extends HashMap<String, Object> {
    private static final long serialVersionUID = -4069212921446859127L;
    private static final String JAVA_EXT = ".java";
    public static final String PARAM_ALIAS = "source-java";
    public static final String PARAM_JAVA_SOURCE = "java-source";
    public static final String PARAM_API_DOCS = "apidocs";
    public static final String PARAM_OVERWRITE = "overwrite";
    public static final String OUT_PARAM_NAME = "name";
    public static final String OUT_PARAM_SIMPLE_NAME = "simpleName";
    public static final String OUT_PARAM_CLASS = "class";
    public static final String OUT_PARAM_JAVA_CLASS = "javaClass";
    public static final String OUT_PARAM_SELECTOR = "select";
    public static final String OUT_PARAM_COMMENT = "comment";
    public static final String OUT_PARAM_TAGS = "tags";
    public static final String OUT_PARAM_ANNOTATIONS = "annotations";
    public static final String OUT_PARAM_FIELDS = "fields";
    public static final String OUT_PARAM_FIELDS_MAP = "fieldsMap";
    public static final String OUT_PARAM_DECLARED_FIELDS = "declaredFields";
    public static final String OUT_PARAM_DECLARED_FIELDS_MAP = "declaredFieldsMap";
    public static final String OUT_PARAM_CONSTANTS = "constants";
    public static final String OUT_PARAM_CONSTANTS_MAP = "constantsMap";
    public static final String OUT_PARAM_DECLARED_CONSTANTS = "declaredConstants";
    public static final String OUT_PARAM_DECLARED_CONSTANTS_MAP = "declaredConstantsMap";
    public static final String OUT_PARAM_PROPERTIES = "properties";
    public static final String OUT_PARAM_PROPERTIES_MAP = "propertiesMap";
    public static final String OUT_PARAM_INTERFACE_METHODS = "interfaceMethods";
    public static final String OUT_PARAM_INTERFACE_METHODS_MAP = "interfaceMethodsMap";
    public static final String OUT_PARAM_METHODS = "methods";
    public static final String OUT_PARAM_METHODS_MAP = "methodsMap";
    JavaClass javaClass;
    String javaDocRootPath = "./apidocs/";
    JavaDocTagsHandler javaDocTagsHandler;

    public JavaSourceLoader(File baseDir, Map<String, Object> requestParams) {
        try {
            String classOrPackageName = (String)requestParams.get(PARAM_JAVA_SOURCE);
            try {
                JavaSource source = this.getSource(baseDir, classOrPackageName);
                this.init(source, requestParams);
            }
            catch (IllegalArgumentException e) {
                JavaPackage javaPackage = this.getPackage(baseDir, classOrPackageName);
                if (javaPackage == null) {
                    throw new IllegalArgumentException("'" + classOrPackageName + "' doesn't seem to be a valid package name nor is it a resolveable java source.", e);
                }
                this.init(javaPackage, requestParams);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaSourceLoader(File baseDir, String className) {
        this(baseDir, Collections.singletonMap(PARAM_JAVA_SOURCE, className));
    }

    protected JavaSourceLoader(JavaClass javaClass, Map<String, Object> requestParams) {
        this.init(javaClass, requestParams);
    }

    protected final void init(JavaSource source, Map<String, Object> requestParams) {
        String className;
        Globals.getLog().debug((CharSequence)("About to load first java class of source '" + source.getURL() + "'."));
        JavaClass[] classes = source.getClasses();
        if (classes.length == 0) {
            throw new IllegalArgumentException("The given source '" + source.getURL() + "' did not contain a single class.");
        }
        JavaClass javaClass = classes[0];
        String string = className = requestParams == null ? null : (String)requestParams.get(PARAM_JAVA_SOURCE);
        if (className != null && className.contains("$") && (javaClass = javaClass.getNestedClassByName(className = className.substring(className.indexOf(36) + 1).replace('$', '.'))) == null) {
            throw new IllegalArgumentException("Did not find nested class: " + className + " in " + classes[0]);
        }
        this.init(javaClass, requestParams);
    }

    protected final void init(JavaClass javaClass, Map<String, Object> requestParams) {
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        this.javaClass = javaClass;
        Object overwrite = null;
        if (requestParams != null) {
            overwrite = requestParams.get(PARAM_OVERWRITE);
            this.putAll(requestParams);
            String apiDocsPath = (String)requestParams.get(PARAM_API_DOCS);
            if (apiDocsPath != null && apiDocsPath.trim().length() != 0) {
                this.javaDocRootPath = apiDocsPath;
            }
        }
        this.javaDocTagsHandler = new JavaDocTagsHandler(javaClass, this.javaDocRootPath, requestParams);
        if (debug) {
            log.debug((CharSequence)("About to load reflection details on class '" + javaClass.getFullyQualifiedName() + "'"));
        }
        this.scanFieldsAndConstants(javaClass);
        this.scanProperties(javaClass);
        this.scanMethods(javaClass);
        this.put(OUT_PARAM_NAME, javaClass.getFullyQualifiedName());
        this.put(OUT_PARAM_SIMPLE_NAME, javaClass.getName());
        this.put(OUT_PARAM_JAVA_CLASS, javaClass);
        this.put(OUT_PARAM_COMMENT, this.javaDocTagsHandler.processJavaDocComment(javaClass.getComment()));
        this.put(OUT_PARAM_ANNOTATIONS, JavaSourceLoader.asMap(javaClass.getAnnotations()));
        this.put(OUT_PARAM_TAGS, this.asMap(javaClass.getTags()));
        this.put(OUT_PARAM_SELECTOR, new SelectorImplementation(javaClass, javaClass.getPackage()));
        if (overwrite == null) {
            this.putAll(requestParams);
        }
        PrintableMap<String, Object> selfIntrospection = new PrintableMap<String, Object>(this, "Reflection details on class '" + javaClass.getFullyQualifiedName() + '\'');
        this.put(OUT_PARAM_CLASS, selfIntrospection);
        if (debug) {
            log.debug((CharSequence)("Loaded: $class=" + selfIntrospection.getContentAsString()));
        }
        if (overwrite != null && !Boolean.parseBoolean(String.valueOf(overwrite))) {
            this.putAll(requestParams);
        }
    }

    protected final void init(JavaPackage javaPackage, Map<String, Object> requestParams) {
        this.put(OUT_PARAM_NAME, javaPackage.getName());
        this.put(OUT_PARAM_SIMPLE_NAME, javaPackage.getName());
        this.put(OUT_PARAM_ANNOTATIONS, JavaSourceLoader.asMap(javaPackage.getAnnotations()));
        this.put(OUT_PARAM_SELECTOR, new SelectorImplementation(null, javaPackage));
    }

    protected final JavaSource getSource(File baseDir, String className) throws IOException {
        if ((className = className.replace('.', '/')).contains("$")) {
            className = className.substring(0, className.indexOf(36));
        }
        if (className.endsWith("/java")) {
            className = className.substring(0, className.length() - 5) + JAVA_EXT;
        } else if (!className.endsWith(JAVA_EXT)) {
            className = className + JAVA_EXT;
        }
        return JavaClassLoader.getInstance().addSource(baseDir, className);
    }

    protected final JavaPackage getPackage(File baseDir, String packageName) throws IOException {
        JavaPackage aPackage = null;
        try {
            for (URL packageUrl : ResourceResolver.findAllSources(baseDir, packageName.replace('.', File.separatorChar))) {
                List files;
                File packagePath = "file".equalsIgnoreCase(packageUrl.getProtocol()) ? new File(packageUrl.toURI()) : null;
                if (packagePath == null || !packagePath.isDirectory() || (files = FileUtils.getFiles((File)packagePath, (String)"**/*.java", (String)"**/package-info.java", (boolean)true)).isEmpty()) continue;
                for (aPackage = JavaClassLoader.getInstance().addSource(((File)files.get(0)).toURI().toURL(), false).getPackage(); aPackage != null && aPackage.getName().startsWith(packageName) && !aPackage.getName().equals(packageName); aPackage = aPackage.getParentPackage()) {
                }
            }
        }
        catch (IllegalArgumentException ignore) {
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return aPackage;
    }

    protected void scanMethods(JavaClass javaClass) {
        SelectableMappedJavaEntitiesList interfaceMethods = new SelectableMappedJavaEntitiesList("method");
        this.put(OUT_PARAM_INTERFACE_METHODS, interfaceMethods);
        SelectableMappedJavaEntitiesList methods = new SelectableMappedJavaEntitiesList("method");
        this.put(OUT_PARAM_METHODS, methods);
        for (JavaMethod method : javaClass.getMethods()) {
            boolean nonVisibleMethod;
            boolean bl = nonVisibleMethod = !method.isPublic() && !method.isProtected();
            if (nonVisibleMethod || method.isConstructor() || method.isPropertyAccessor() || method.isPropertyMutator()) continue;
            PrintableMap<String, Map<String, Map>> parameterAnnotations = new PrintableMap<String, Map<String, Map>>("Parameter-Annotations");
            if (method.getParameters() != null) {
                for (JavaParameter parameter : method.getParameters()) {
                    parameterAnnotations.put(parameter.getName(), JavaSourceLoader.asMap(parameter.getAnnotations()));
                }
            }
            Map<Object, Object> row = JavaSourceLoader.asMap("type", JavaSourceLoader.typeToString(method.getReturnType()), OUT_PARAM_NAME, method.getName(), "signature", method.getCallSignature(), OUT_PARAM_COMMENT, this.javaDocTagsHandler.processJavaDocComment(method.getComment()), OUT_PARAM_TAGS, this.asMap(method.getTags()), "method", method, OUT_PARAM_ANNOTATIONS, JavaSourceLoader.asMap(method.getAnnotations()), "parameterAnnotations", parameterAnnotations);
            if (method.isAbstract()) {
                interfaceMethods.add(row);
                continue;
            }
            methods.add(row);
        }
        this.put(OUT_PARAM_INTERFACE_METHODS_MAP, JavaSourceLoader.asMap(interfaceMethods, OUT_PARAM_NAME));
        this.put(OUT_PARAM_METHODS_MAP, JavaSourceLoader.asMap(methods, OUT_PARAM_NAME));
    }

    protected void scanProperties(JavaClass javaClass) {
        SelectableMappedJavaEntitiesList properties = new SelectableMappedJavaEntitiesList("property");
        this.put(OUT_PARAM_PROPERTIES, properties);
        for (BeanProperty property : javaClass.getBeanProperties()) {
            JavaMethod getter = property.getAccessor();
            JavaMethod setter = property.getMutator();
            JavaField field = javaClass.getFieldByName(property.getName());
            PrintableMap<String, Map> annotations = new PrintableMap<String, Map>("Annotations");
            if (getter != null) {
                annotations.putAll(JavaSourceLoader.asMap(getter.getAnnotations()));
            }
            if (setter != null) {
                annotations.putAll(JavaSourceLoader.asMap(setter.getAnnotations()));
            }
            if (field != null) {
                annotations.putAll(JavaSourceLoader.asMap(field.getAnnotations()));
            }
            Object[] objectArray = new Object[24];
            objectArray[0] = "type";
            objectArray[1] = JavaSourceLoader.typeToString(property.getType());
            objectArray[2] = OUT_PARAM_NAME;
            objectArray[3] = property.getName();
            objectArray[4] = OUT_PARAM_COMMENT;
            objectArray[5] = this.javaDocTagsHandler.processJavaDocComment(getter == null ? "" : (getter.getComment() == null ? (field == null ? "" : field.getComment()) : getter.getComment()));
            objectArray[6] = OUT_PARAM_TAGS;
            objectArray[7] = getter == null ? (field == null ? Collections.emptyMap() : this.asMap(field.getTags())) : this.asMap(getter.getTags());
            objectArray[8] = "setterComment";
            objectArray[9] = this.javaDocTagsHandler.processJavaDocComment(setter == null ? "" : setter.getComment());
            objectArray[10] = "setterTags";
            objectArray[11] = setter == null ? Collections.emptyMap() : this.asMap(setter.getTags());
            objectArray[12] = "property";
            objectArray[13] = property;
            objectArray[14] = "getter";
            objectArray[15] = getter;
            objectArray[16] = "setter";
            objectArray[17] = setter;
            objectArray[18] = "field";
            objectArray[19] = field;
            objectArray[20] = "value";
            objectArray[21] = field == null ? "" : field.getInitializationExpression();
            objectArray[22] = OUT_PARAM_ANNOTATIONS;
            objectArray[23] = annotations;
            Map<Object, Object> row = JavaSourceLoader.asMap(objectArray);
            properties.add(row);
        }
        this.put(OUT_PARAM_PROPERTIES_MAP, JavaSourceLoader.asMap(properties, OUT_PARAM_NAME));
    }

    protected void scanFieldsAndConstants(JavaClass javaClass) {
        SelectableMappedJavaEntitiesList constants = new SelectableMappedJavaEntitiesList("field");
        SelectableMappedJavaEntitiesList declaredConstants = new SelectableMappedJavaEntitiesList("field");
        this.put(OUT_PARAM_CONSTANTS, constants);
        this.put(OUT_PARAM_DECLARED_CONSTANTS, declaredConstants);
        SelectableMappedJavaEntitiesList fields = new SelectableMappedJavaEntitiesList("field");
        SelectableMappedJavaEntitiesList declaredFields = new SelectableMappedJavaEntitiesList("field");
        this.put(OUT_PARAM_FIELDS, fields);
        this.put(OUT_PARAM_DECLARED_FIELDS, declaredFields);
        boolean classIsInterface = javaClass.isInterface();
        for (JavaField field : javaClass.getFields()) {
            boolean fieldIsConstant = classIsInterface || field.isFinal() && field.isStatic();
            Map<Object, Object> row = JavaSourceLoader.asMap("type", JavaSourceLoader.typeToString(field.getType()), OUT_PARAM_NAME, field.getName(), "value", field.getInitializationExpression(), OUT_PARAM_COMMENT, this.javaDocTagsHandler.processJavaDocComment(field.getComment()), OUT_PARAM_TAGS, this.asMap(field.getTags()), "field", field, OUT_PARAM_ANNOTATIONS, JavaSourceLoader.asMap(field.getAnnotations()));
            (fieldIsConstant ? declaredConstants : declaredFields).add(row);
            if (!field.isPublic() && !field.isProtected() && !classIsInterface) continue;
            (fieldIsConstant ? constants : fields).add(row);
        }
        this.put(OUT_PARAM_CONSTANTS_MAP, JavaSourceLoader.asMap(constants, OUT_PARAM_NAME));
        this.put(OUT_PARAM_DECLARED_CONSTANTS_MAP, JavaSourceLoader.asMap(declaredConstants, OUT_PARAM_NAME));
        this.put(OUT_PARAM_FIELDS_MAP, JavaSourceLoader.asMap(fields, OUT_PARAM_NAME));
        this.put(OUT_PARAM_DECLARED_FIELDS_MAP, JavaSourceLoader.asMap(declaredFields, OUT_PARAM_NAME));
    }

    protected Map<String, Object> asMap(DocletTag ... tags) {
        PrintableMap<String, Object> result = new PrintableMap<String, Object>("Doclet-Tags");
        for (DocletTag tag : tags) {
            Map<String, Object> targetMap = result;
            String name = tag.getName();
            String value = tag.getValue();
            if ("see".equalsIgnoreCase(name)) {
                value = "{@link " + value + '}';
            } else if ("param".equalsIgnoreCase(name)) {
                if (tag.getParameters().length <= 0) continue;
                name = tag.getParameters()[0];
                if (result.containsKey("param")) {
                    targetMap = (Map)result.get("param");
                } else {
                    targetMap = new PrintableMap("Method-Params-Tags");
                    result.put("param", targetMap);
                }
            }
            targetMap.put(name, this.javaDocTagsHandler.processJavaDocComment(value));
        }
        return result;
    }

    protected static String typeToString(Type type) {
        return type == null ? "" : type.toGenericString();
    }

    protected static Map<String, Map> asMap(Annotation ... annotations) {
        PrintableMap<String, Map> result = new PrintableMap<String, Map>("Annotations");
        for (Annotation annotation : annotations) {
            String name = annotation.getType().getFullyQualifiedName();
            name = "@".concat(name.substring(name.lastIndexOf(46) + 1));
            PrintableMap map = new PrintableMap("Annotation-Parameters");
            map.putAll(annotation.getNamedParameterMap());
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.setValue(entry.getValue().toString().trim());
            }
            result.put(name, map);
        }
        return result;
    }

    protected static Map<Object, Object> asMap(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("The key and value input array length must be a multiple of 2.");
        }
        PrintableMap<Object, Object> map = new PrintableMap<Object, Object>("Key-Value-Pairs");
        LinkedHashMap<String, Object> assocMap = new LinkedHashMap<String, Object>(keyValuePairs.length / 2);
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = String.valueOf(keyValuePairs[i]);
            Object value = keyValuePairs[i + 1];
            map.put(i / 2, value);
            assocMap.put(key, value);
        }
        map.putAll(assocMap);
        return map;
    }

    protected static Map<String, Map<?, ?>> asMap(Iterable<Map<?, ?>> namedRows, String nameKey) {
        PrintableMap map = new PrintableMap("Named-Class-Elements");
        for (Map<?, ?> namedRow : namedRows) {
            map.put((String)namedRow.get(nameKey), namedRow);
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectorImplementation
    implements Selector {
        private final JavaClass javaClass;
        private final JavaPackage javaPackage;

        SelectorImplementation(JavaClass javaClass, JavaPackage javaPackage) {
            this.javaClass = javaClass;
            this.javaPackage = javaPackage;
        }

        Map<String, Object> extractRequestParams() {
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            for (Map.Entry entry : JavaSourceLoader.this.entrySet()) {
                if (!((String)entry.getKey()).startsWith(JavaSourceLoader.PARAM_API_DOCS)) continue;
                requestParams.put((String)entry.getKey(), entry.getValue());
            }
            return requestParams;
        }

        List<Map<String, ?>> convert(Collection<JavaClass> classes) {
            return this.convert(classes.toArray(new JavaClass[classes.size()]));
        }

        List<Map<String, ?>> convert(JavaClass[] classes) {
            Map<String, Object> requestParams = this.extractRequestParams();
            ArrayList sourceLoaders = new ArrayList(classes.length);
            for (JavaClass aClass : classes) {
                sourceLoaders.add(new PrintableMap<String, Object>(new JavaSourceLoader(aClass, requestParams), aClass.toString()));
            }
            return sourceLoaders;
        }

        @Override
        public SelectableMappedJavaEntitiesList getPackageClasses() {
            JavaClass[] classes = this.javaPackage == null ? new JavaClass[]{} : this.javaPackage.getClasses();
            return new SelectableMappedJavaEntitiesList(this.convert(classes), JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getClassesBelowPackage() {
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            if (this.javaPackage == null) {
                classes.addAll(JavaClassLoader.getInstance().getClasses());
            } else {
                String prefix = this.javaPackage.getName() + '.';
                for (JavaPackage candidate : JavaClassLoader.getInstance().getPackages()) {
                    if (!candidate.equals((Object)this.javaPackage) && !candidate.getName().startsWith(prefix)) continue;
                    classes.addAll(Arrays.asList(candidate.getClasses()));
                }
            }
            return new SelectableMappedJavaEntitiesList(this.convert(classes), JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getNestedClasses() {
            JavaClass[] nestedClasses = this.javaClass == null ? new JavaClass[]{} : this.javaClass.getNestedClasses();
            return new SelectableMappedJavaEntitiesList(this.convert(nestedClasses), JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getSuperClasses() {
            ArrayList<JavaClass> knownSuperClasses = new ArrayList<JavaClass>();
            if (this.javaClass != null) {
                for (JavaClass superClass = this.javaClass.getSuperJavaClass(); superClass != null; superClass = superClass.getSuperJavaClass()) {
                    knownSuperClasses.add(superClass);
                }
            }
            List<Map<String, ?>> mapList = this.convert(knownSuperClasses.toArray(new JavaClass[knownSuperClasses.size()]));
            return new SelectableMappedJavaEntitiesList(mapList, JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getImplementedInterfaces() {
            JavaClass[] interfaces = this.javaClass == null ? new JavaClass[]{} : this.javaClass.getImplementedInterfaces();
            return new SelectableMappedJavaEntitiesList(this.convert(interfaces), JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getDerivedClasses() {
            JavaClass[] classes = this.javaClass == null ? new JavaClass[]{} : this.javaClass.getDerivedClasses();
            return new SelectableMappedJavaEntitiesList(this.convert(classes), JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }

        @Override
        public SelectableMappedJavaEntitiesList getAnnotatedClasses() {
            if (!SelectableMappedJavaEntitiesList.isAnnotation(this.javaClass)) {
                throw new IllegalStateException("Cannot look after classes that are annotated with '" + this.javaClass + "' as this class is no annotation.");
            }
            SortedSet<JavaClass> allClasses = JavaClassLoader.getInstance().getClasses();
            SelectableJavaEntitiesList<JavaClass> entitiesList = new SelectableJavaEntitiesList<JavaClass>(allClasses);
            List<Map<String, ?>> converted = this.convert(entitiesList.selectAnnotated('@' + this.javaClass.getFullyQualifiedName()));
            return new SelectableMappedJavaEntitiesList(converted, JavaSourceLoader.OUT_PARAM_JAVA_CLASS);
        }
    }

    public static interface Selector {
        public SelectableMappedJavaEntitiesList getPackageClasses();

        public SelectableMappedJavaEntitiesList getClassesBelowPackage();

        public SelectableMappedJavaEntitiesList getNestedClasses();

        public SelectableMappedJavaEntitiesList getSuperClasses();

        public SelectableMappedJavaEntitiesList getImplementedInterfaces();

        public SelectableMappedJavaEntitiesList getDerivedClasses();

        public SelectableMappedJavaEntitiesList getAnnotatedClasses();
    }

    public static class AliasHandler
    extends AbstractAliasHandler {
        public AliasHandler() {
            super(JavaSourceLoader.PARAM_ALIAS, JavaSourceLoader.PARAM_JAVA_SOURCE, JavaSourceLoader.class.getName());
        }
    }
}

