/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import com.thoughtworks.qdox.model.JavaClass;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.doxia.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.spi.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDocTagsHandler
implements Serializable {
    private static final long serialVersionUID = 689877916746238765L;
    private JavaClass javaClass;
    private String javaDocRootPath;
    private Map<String, Object> packageMappings;

    public JavaDocTagsHandler() {
    }

    public JavaDocTagsHandler(JavaClass javaClass, String javaDocRootPath, Map<String, Object> packageMappings) {
        this.javaClass = javaClass;
        this.javaDocRootPath = javaDocRootPath;
        this.packageMappings = packageMappings == null ? Collections.emptyMap() : packageMappings;
        Log log = Globals.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Created new JavaDocTagsHandler for class '" + javaClass.getFullyQualifiedName() + "' linking to " + "javaDocRootPath='" + javaDocRootPath + "'."));
            for (Map.Entry<String, Object> entry : this.packageMappings.entrySet()) {
                if (!entry.getKey().startsWith("apidocs") || "apidocs".equals(entry.getKey())) continue;
                log.debug((CharSequence)("Package '" + entry.getKey().substring("apidocs".length() + 1) + "' is linked to:" + entry.getValue()));
            }
        }
    }

    public String processJavaDocComment(String comment) {
        if (comment == null) {
            return comment;
        }
        Log log = Globals.getLog();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((CharSequence)("About to process inline javadoc tags in comment '" + comment + '\''));
        }
        StringBuilder buffer = new StringBuilder(comment.length());
        StringTokenizer tokenizer = new StringTokenizer(comment, "{}", true);
        int openBraceCount = 0;
        boolean previousIsOpenBrace = false;
        String currentInlineTag = null;
        block4: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case '{': {
                    ++openBraceCount;
                    previousIsOpenBrace = true;
                    continue block4;
                }
                case '}': {
                    if (--openBraceCount > 0) break;
                    openBraceCount = 0;
                    if (currentInlineTag != null) {
                        token = this.handleJavaDocInlineTagClose(currentInlineTag);
                    }
                    currentInlineTag = null;
                }
            }
            if (previousIsOpenBrace) {
                if (currentInlineTag == null && token.startsWith("@")) {
                    boolean containsWhitespace = token.contains(" ");
                    currentInlineTag = containsWhitespace ? token.substring(1, token.indexOf(32)) : token.substring(1);
                    token = token.substring((containsWhitespace ? 2 : 1) + currentInlineTag.length());
                    token = this.handleJavaDocInlineTagContent(currentInlineTag, token, true);
                } else {
                    if (currentInlineTag == null) {
                        openBraceCount = 0;
                    }
                    buffer.append('{');
                }
            } else if (currentInlineTag != null) {
                token = this.handleJavaDocInlineTagContent(currentInlineTag, token, false);
            }
            buffer.append(token);
            previousIsOpenBrace = false;
        }
        if (debug) {
            log.debug((CharSequence)("Process result '" + buffer + '\''));
        }
        return buffer.toString();
    }

    String handleJavaDocInlineTagContent(String tag, String content, boolean first) {
        boolean isPlainLink = "linkplain".equalsIgnoreCase(tag);
        if ("link".equals(tag) || isPlainLink) {
            try {
                return first ? this.createApiDocsLink(content, isPlainLink) : "";
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if ("docRoot".equalsIgnoreCase(tag)) {
            return this.javaDocRootPath;
        }
        boolean isCode = "code".equals(tag);
        if (isCode || "literal".equals(tag)) {
            content = content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            if (isCode) {
                content = content.replaceAll("(\\n\\r|\\n|\\r)", "<br/>\n");
            }
            return first ? (isCode ? "<code>" : "") + content : content;
        }
        return content;
    }

    String handleJavaDocInlineTagClose(String tag) {
        if ("code".equals(tag)) {
            return "</code>";
        }
        return "";
    }

    String createApiDocsLink(String content, boolean isPlainLink) throws UnsupportedEncodingException {
        int anchorIndex;
        String fullyQualifiedType;
        int firstWhitespace;
        String linkText = "";
        if (content.contains(" ") && (firstWhitespace = content.indexOf(32, Math.max(0, content.indexOf(41)))) != -1) {
            linkText = content.substring(firstWhitespace + 1).trim();
            content = content.substring(0, firstWhitespace).trim();
        }
        if ((fullyQualifiedType = this.javaClass.resolveType((anchorIndex = content.indexOf(35)) == -1 ? content : content.substring(0, anchorIndex))) == null) {
            fullyQualifiedType = content;
        } else if (anchorIndex != -1) {
            fullyQualifiedType = fullyQualifiedType + content.substring(anchorIndex);
        }
        String linkBase = this.findLinkBaseForType(fullyQualifiedType);
        String linkTarget = fullyQualifiedType.replace('.', '/');
        if (StringUtils.isEmpty((String)linkText)) {
            String string = linkText = linkTarget.contains("/") ? linkTarget.substring(linkTarget.lastIndexOf(47) + 1) : linkTarget;
        }
        if ((anchorIndex = linkTarget.indexOf(35)) != -1) {
            String fragment = linkTarget.substring(anchorIndex + 1);
            linkTarget = linkTarget.substring(0, anchorIndex) + ".html#" + URLEncoder.encode(fragment, "UTF-8");
        } else {
            linkTarget = linkTarget + ".html";
        }
        if (!isPlainLink) {
            linkText = "<code>" + linkText + "</code>";
        }
        return "<a href=\"" + linkBase + linkTarget.replace('$', '.') + "\" title=\"" + fullyQualifiedType + "\">" + linkText + "</a>";
    }

    String findLinkBaseForType(String fullyQualifiedType) {
        String linkBase = this.javaDocRootPath;
        StringBuilder packageName = new StringBuilder(fullyQualifiedType.length()).append("apidocs").append('-');
        for (String part : fullyQualifiedType.split("\\.")) {
            if (packageName.length() > "apidocs".length() + 1) {
                packageName.append('.');
            }
            packageName.append(part);
            Object otherLinkBase = this.packageMappings.get(packageName.toString());
            if (otherLinkBase == null) continue;
            linkBase = otherLinkBase.toString();
        }
        return linkBase;
    }

    public String toString() {
        return "JavaDocTagsHandler{javaClass=" + this.javaClass + ", javaDocRootPath='" + this.javaDocRootPath + '\'' + ", packageMappings=" + this.packageMappings + '}';
    }
}

