/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim.extensions;

import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.tinyjee.maven.dim.extensions.JavaSourceLoader;
import org.tinyjee.maven.dim.extensions.PropertiesLoader;
import org.tinyjee.maven.dim.extensions.SelectableMappedJavaEntitiesList;
import org.tinyjee.maven.dim.extensions.XmlLoader;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.utils.AbstractAliasHandler;
import org.tinyjee.maven.dim.utils.JavaClassLoader;
import org.tinyjee.maven.dim.utils.PrintableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryLoader
extends HashMap<String, Object> {
    private static final long serialVersionUID = -3519896231202791446L;
    protected static final Map<String, Class<? extends Map<String, Object>>> EXTENSION_TO_LOADER_MAPPING = new HashMap<String, Class<? extends Map<String, Object>>>();
    protected static final Map<Class, String> FILE_INPUT_PARAM_MAP = new HashMap<Class, String>();
    public static final String PARAM_ALIAS = "source-directories";
    public static final String PARAM_DIRECTORIES = "directories";
    public static final String PARAM_OUT_FILES = "files";
    public static final String PARAM_OUT_XML_FILES = "xmlFiles";
    public static final String PARAM_OUT_PROPERTY_FILES = "propertyFiles";
    public static final String PARAM_OUT_JAVA_CLASSES = "javaClasses";

    public DirectoryLoader(File baseDir, Map<String, Object> requestParams) {
        String[] directoriesList;
        this.putAll(requestParams);
        JavaClassLoader javaClassLoader = JavaClassLoader.getInstance();
        for (String directory : directoriesList = String.valueOf(requestParams.get(PARAM_DIRECTORIES)).split("\\s*,\\s*")) {
            URL directoryUrl = ResourceResolver.findSource(baseDir, directory);
            if (!"file".equalsIgnoreCase(directoryUrl.getProtocol())) {
                throw new IllegalArgumentException("Cannot handle remote directories " + directoryUrl);
            }
            try {
                javaClassLoader.addSourceTree(new File(directoryUrl.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        SortedSet<JavaClass> allClasses = javaClassLoader.getClasses();
        SelectableMappedJavaEntitiesList allSelectableClasses = new SelectableMappedJavaEntitiesList("javaClass");
        for (JavaClass javaClass : allClasses) {
            allSelectableClasses.add(new PrintableMap<String, Object>(new JavaSourceLoader(javaClass, requestParams), javaClass.getFullyQualifiedName()));
        }
        this.put(PARAM_OUT_JAVA_CLASSES, allSelectableClasses);
    }

    static {
        EXTENSION_TO_LOADER_MAPPING.put(".xml", XmlLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".xsl", XmlLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".xdoc", XmlLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".xhtml", XmlLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".json", XmlLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".java", JavaSourceLoader.class);
        EXTENSION_TO_LOADER_MAPPING.put(".properties", PropertiesLoader.class);
        FILE_INPUT_PARAM_MAP.put(XmlLoader.class, "xml");
        FILE_INPUT_PARAM_MAP.put(JavaSourceLoader.class, "java-source");
        FILE_INPUT_PARAM_MAP.put(PropertiesLoader.class, "properties");
    }

    static interface FileReference {
        public File getFile();

        public URI getFileUri();

        public Object getContent();
    }

    public static class AliasHandler
    extends AbstractAliasHandler {
        public AliasHandler() {
            super(DirectoryLoader.PARAM_ALIAS, DirectoryLoader.PARAM_DIRECTORIES, DirectoryLoader.class.getName());
        }
    }
}

