/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim;

import java.util.Map;
import org.apache.maven.doxia.logging.Log;
import org.tinyjee.maven.dim.MacroPreset;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.RequestParameterTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroPresetParameterTransformer
implements RequestParameterTransformer {
    static final String KEY_PRESET = "preset";
    static final String DEFAULT_PRESET = "default";

    @Override
    public void transformParameters(Map<String, Object> requestParams) {
        MacroPreset preset;
        Object presetName = requestParams.get(KEY_PRESET);
        if (presetName == null && MacroPreset.decodeFrom((presetName = DEFAULT_PRESET).toString(), System.getProperties()) == null) {
            return;
        }
        String name = presetName.toString();
        Log logger = Globals.getLog();
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.debug((CharSequence)("Looking for after named properties preset '" + name + "', " + "properties before applying preset are: " + requestParams));
        }
        if ((preset = MacroPreset.decodeFrom(name, System.getProperties())) != null) {
            Map<String, String> properties = preset.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (requestParams.containsKey(entry.getKey())) continue;
                requestParams.put(entry.getKey(), entry.getValue());
            }
        } else {
            logger.error((CharSequence)("Did not find a defined properties preset that is named: '" + name + '\''));
        }
        if (debug) {
            logger.debug((CharSequence)("Properties after applying preset are: " + requestParams));
        }
    }
}

