/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.MacroPreset;
import org.tinyjee.maven.dim.spi.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeMacroMojo
extends AbstractMojo {
    private File basedir;
    private MavenProject project;
    private boolean exportAdditionalProjectPaths = true;
    private boolean exportProjectClasspath = true;
    private String inputEncoding;
    private String siteDirectory;
    private String attachedIncludesDirectory = "attached-includes";
    private boolean generateAttachedIncludesInBuildDirectory;
    private boolean defaultShowGutter = true;
    private boolean verbose;
    private MacroPreset[] presets;

    public static void reset() {
        Properties properties = System.getProperties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith("org.tinyjee.maven.dim.project.")) continue;
            iterator.remove();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Setting system property 'basedir' to " + this.basedir));
        System.setProperty("basedir", this.basedir.getAbsolutePath());
        if (this.presets != null) {
            for (MacroPreset preset : this.presets) {
                preset.encodeTo(System.getProperties());
            }
        }
        System.setProperty("dim.verbose", String.valueOf(this.verbose));
        System.setProperty("org.tinyjee.maven.dim.defaultShowGutter", String.valueOf(this.defaultShowGutter));
        System.setProperty("org.tinyjee.maven.dim.attachedIncludesDirectory", this.attachedIncludesDirectory);
        System.setProperty("org.tinyjee.maven.dim.generateAttachedIncludesInBuildDirectory", String.valueOf(this.generateAttachedIncludesInBuildDirectory));
        System.setProperty("org.tinyjee.maven.dim.project.inputEncoding", this.inputEncoding);
        System.setProperty("org.tinyjee.maven.dim.project.siteDirectory", this.siteDirectory);
        Build build = this.project.getBuild();
        System.setProperty("org.tinyjee.maven.dim.project.scriptSourceDirectory", build.getScriptSourceDirectory());
        System.setProperty("org.tinyjee.maven.dim.project.sourceDirectory", build.getSourceDirectory());
        System.setProperty("org.tinyjee.maven.dim.project.resourceDirectories", InitializeMacroMojo.getResourcePaths(build.getResources()));
        System.setProperty("org.tinyjee.maven.dim.project.outputDirectory", build.getOutputDirectory());
        System.setProperty("org.tinyjee.maven.dim.project.testSourceDirectory", build.getTestSourceDirectory());
        System.setProperty("org.tinyjee.maven.dim.project.testResourceDirectories", InitializeMacroMojo.getResourcePaths(build.getTestResources()));
        System.setProperty("org.tinyjee.maven.dim.project.testOutputDirectory", build.getTestOutputDirectory());
        System.setProperty("org.tinyjee.maven.dim.project.targetDirectory", build.getDirectory());
        if (this.exportProjectClasspath) {
            this.getLog().debug((CharSequence)"Exporting the project class path.");
            try {
                this.exportProjectClassPath();
            }
            catch (DependencyResolutionRequiredException ignored) {
                this.getLog().warn((CharSequence)"Failed exporting 'project.classpath' and 'project.test.classpath' as artifacts require resolving. 'doxia include macro' may fail on a 'source-class' that requires any non-JDK dependencies.");
            }
        }
        if (this.exportAdditionalProjectPaths) {
            this.getLog().debug((CharSequence)"Exporting additional module paths to allow artifactId based path definitions.");
            HashSet<MavenProject> alreadyHandled = new HashSet<MavenProject>();
            for (MavenProject p = this.project; p != null && p.getBasedir() != null; p = p.getParent()) {
                InitializeMacroMojo.exportProjectPaths(p, alreadyHandled);
            }
        }
    }

    private void exportProjectClassPath() throws DependencyResolutionRequiredException {
        LinkedHashSet classPath = new LinkedHashSet();
        classPath.addAll(this.project.getCompileClasspathElements());
        classPath.addAll(this.project.getRuntimeClasspathElements());
        System.setProperty("org.tinyjee.maven.dim.include.project.classpath", StringUtils.join(classPath.iterator(), (String)File.pathSeparator));
        classPath.clear();
        classPath.addAll(this.project.getTestClasspathElements());
        System.setProperty("org.tinyjee.maven.dim.include.project.test.classpath", StringUtils.join(classPath.iterator(), (String)File.pathSeparator));
    }

    private static void exportProjectPaths(MavenProject project, Set<MavenProject> alreadyHandled) {
        boolean isTopMostProject;
        File baseDir;
        File file = baseDir = project == null ? null : project.getBasedir();
        if (baseDir == null || alreadyHandled.contains(project)) {
            return;
        }
        String baseUri = baseDir.toURI().toString();
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        boolean bl = isTopMostProject = project.getParent() == null || project.getParent().getBasedir() == null;
        if (isTopMostProject) {
            ResourceResolver.setModulePath("top", "top", baseDir);
        }
        ResourceResolver.setModulePath(groupId, artifactId, baseDir);
        List<Properties> allProperties = Arrays.asList(project.getProperties(), System.getProperties());
        for (Properties properties : allProperties) {
            properties.setProperty("dim." + groupId + '_' + artifactId + ".basedir", baseDir.toString());
            properties.setProperty("dim." + groupId + '_' + artifactId + ".baseUri", baseUri);
            properties.setProperty("dim." + artifactId + ".basedir", baseDir.toString());
            properties.setProperty("dim." + artifactId + ".baseUri", baseUri);
            if (!isTopMostProject) continue;
            properties.setProperty("dim.top.basedir", baseDir.toString());
            properties.setProperty("dim.top.baseUri", baseUri);
        }
        alreadyHandled.add(project);
        if (project.getCollectedProjects() != null) {
            for (Properties projectReference : project.getCollectedProjects()) {
                InitializeMacroMojo.exportProjectPaths((MavenProject)projectReference, alreadyHandled);
            }
        }
    }

    private static String getResourcePaths(List resources) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Object rawResource : resources) {
            Resource resource = (Resource)rawResource;
            paths.add(resource.getDirectory());
        }
        return StringUtils.join(paths.iterator(), (String)File.pathSeparator);
    }
}

