/*
 * Decompiled with CFR 0.152.
 */
package org.tinyjee.maven.dim;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.SystemStreamLog;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroManager;
import org.apache.maven.doxia.module.apt.AptParser;
import org.apache.maven.doxia.module.fml.FmlParser;
import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.tinyjee.maven.dim.sh.CodeHighlighter;
import org.tinyjee.maven.dim.sources.MergeSource;
import org.tinyjee.maven.dim.sources.SourceClassAdapter;
import org.tinyjee.maven.dim.sources.TemplateSource;
import org.tinyjee.maven.dim.sources.UrlSource;
import org.tinyjee.maven.dim.spi.AbstractSource;
import org.tinyjee.maven.dim.spi.FixedContentSource;
import org.tinyjee.maven.dim.spi.Globals;
import org.tinyjee.maven.dim.spi.RequestParameterTransformer;
import org.tinyjee.maven.dim.spi.ResourceResolver;
import org.tinyjee.maven.dim.spi.SnippetExtractor;
import org.tinyjee.maven.dim.spi.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeMacro
extends AbstractMacro
implements Contextualizable {
    public static final String RESOURCES_FOLDER_NAME = "resources";
    public static final String VELOCITY_TEMPLATE_EXTENSION = ".vm";
    private CodeHighlighter highlighter;
    private PlexusContainer container;

    public CodeHighlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new CodeHighlighter();
        }
        return this.highlighter;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private static void importSourceParameters(Source source, Map<String, String> textParameters) {
        if (source != null) {
            for (Map.Entry<String, Object> entry : source.getContent().getParameters().entrySet()) {
                if (entry.getValue() == null) continue;
                textParameters.put(entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Log logger = this.getLogger();
        if (Boolean.getBoolean("dim.verbose")) {
            logger.setLogLevel(0);
        }
        Globals.initializeGlobals(null, sink, request, logger, null);
        try {
            File basePath = request.getBasedir();
            Map parameters = request.getParameters();
            for (RequestParameterTransformer transformer : RequestParameterTransformer.TRANSFORMERS) {
                transformer.transformParameters(parameters);
            }
            Map<String, String> textParameters = this.extractTextParameters(parameters);
            File attachedIncludesDirectory = this.findSiteAttachedIncludesDirectory(basePath, textParameters);
            Globals.reInitializeGlobals(textParameters.get("charset"), sink, request, logger, attachedIncludesDirectory);
            Source source = this.findSource(basePath, textParameters);
            if (source == null) {
                StringBuilder builder = new StringBuilder(1024).append("No source was found, one of the parameters 'source', 'file', 'source-content' or 'source-class' is required, the parameters present at the macro call were:");
                for (Map.Entry<String, String> entry : textParameters.entrySet()) {
                    builder.append('\n').append(entry.getKey()).append('=').append(entry.getValue());
                }
                throw new MacroExecutionException(builder.toString());
            }
            IncludeMacro.importSourceParameters(source, textParameters);
            this.processSource(textParameters, basePath, source, sink);
        }
        catch (RuntimeException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
        finally {
            Globals.cleanupGlobals();
        }
    }

    protected Source findSource(File basePath, Map<String, String> textParameters) throws MacroExecutionException {
        boolean sourceHasTemplateExtension;
        String sourceClass;
        URL sourceUrl = this.findSourceURL(basePath, textParameters);
        Source source = null;
        AbstractSource contentSource = null;
        String sourceContent = textParameters.get("source-content");
        if (!StringUtils.isEmpty((String)sourceContent)) {
            if (!textParameters.containsKey("source-is-template")) {
                textParameters.put("source-is-template", String.valueOf(true));
            }
            if (!textParameters.containsKey("verbatim")) {
                textParameters.put("verbatim", String.valueOf(false));
            }
            Map<String, Object> parameters = textParameters;
            contentSource = new FixedContentSource(sourceContent, parameters);
        }
        if ((sourceClass = textParameters.get("source-class")) != null) {
            source = new SourceClassAdapter(basePath, textParameters, sourceClass);
        }
        if (sourceUrl == null && source != null) {
            IncludeMacro.importSourceParameters(source, textParameters);
            sourceUrl = this.findSourceURL(basePath, textParameters);
            Globals globals = Globals.getInstance();
            Sink sink = globals.getSink();
            MacroRequest request = globals.getRequest();
            Log logger = globals.getLogger();
            File attachedIncludesDirectory = globals.getAttachedIncludesPath();
            Globals.reInitializeGlobals((String)textParameters.get("charset"), sink, request, logger, attachedIncludesDirectory);
        }
        if (sourceUrl != null) {
            Map<String, Object> parameters = textParameters;
            contentSource = new UrlSource(sourceUrl, parameters);
        }
        if (contentSource != null) {
            source = source != null ? new MergeSource(contentSource, source) : contentSource;
        }
        String rawSourceIsTemplate = (String)textParameters.get("source-is-template");
        boolean bl = sourceHasTemplateExtension = sourceUrl != null && sourceUrl.getPath().toLowerCase(Locale.ENGLISH).endsWith(VELOCITY_TEMPLATE_EXTENSION);
        if (sourceHasTemplateExtension || Boolean.parseBoolean(rawSourceIsTemplate)) {
            boolean velocitySourceCanBeHighlighted;
            boolean templateIsDisabled = rawSourceIsTemplate != null && !Boolean.parseBoolean(rawSourceIsTemplate);
            boolean bl2 = velocitySourceCanBeHighlighted = templateIsDisabled && !"plain".equals(this.getHighlighter().findBrushName(sourceUrl, Collections.<Integer, List<String>>emptyMap(), textParameters));
            if (sourceHasTemplateExtension && !velocitySourceCanBeHighlighted) {
                try {
                    sourceUrl = new URL(sourceUrl.toExternalForm().replace(VELOCITY_TEMPLATE_EXTENSION, ""));
                }
                catch (MalformedURLException e) {
                    throw new MacroExecutionException(e.getMessage(), (Throwable)e);
                }
            }
            if (!templateIsDisabled) {
                source = new TemplateSource(sourceUrl, source);
            }
        }
        return source;
    }

    protected URL findSourceURL(File basePath, Map<String, String> parameters) throws MacroExecutionException {
        String file;
        URL sourceUrl;
        block16: {
            sourceUrl = null;
            String rawSource = parameters.get("source");
            if (!StringUtils.isEmpty((String)rawSource)) {
                try {
                    sourceUrl = ResourceResolver.findSource(basePath, rawSource);
                }
                catch (IllegalArgumentException e) {
                    if (!rawSource.contains("/") && !rawSource.contains("\\")) {
                        try {
                            sourceUrl = ResourceResolver.findSource(basePath, rawSource.replace('.', '/') + ".java");
                        }
                        catch (IllegalArgumentException ignored) {}
                    } else if (!rawSource.matches("^[a-zA-Z]{2,}:[/]{1,3}.+")) {
                        String sourceUri;
                        String baseUri;
                        try {
                            baseUri = basePath.getCanonicalFile().toURI().toASCIIString();
                            sourceUri = rawSource.startsWith(baseUri) ? rawSource : new File(rawSource).getCanonicalFile().toURI().toASCIIString();
                        }
                        catch (IOException ioException) {
                            throw new MacroExecutionException("Failed to create canonical paths of source '" + rawSource + "' or base path '" + basePath + "' on the attempt to find a common path prefix for the 2 paths.\n" + "The source resolution failed in the second attempt as a previous lookup " + "already failed with:\n" + e.getMessage(), (Throwable)ioException);
                        }
                        if (sourceUri.startsWith(baseUri)) {
                            try {
                                sourceUrl = ResourceResolver.findSource(basePath, sourceUri.substring(baseUri.length()));
                            }
                            catch (IllegalArgumentException almostIgnored) {
                                Globals.getLog().info((CharSequence)almostIgnored.getMessage());
                            }
                        }
                    }
                    if (sourceUrl != null) break block16;
                    throw new MacroExecutionException("Cannot resolve 'source':" + rawSource, (Throwable)e);
                }
            }
        }
        if (!StringUtils.isEmpty((String)(file = parameters.get("file")))) {
            try {
                sourceUrl = (ResourceResolver.isAbsolute(file) ? new File(file) : new File(basePath, file)).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MacroExecutionException(file, (Throwable)e);
            }
        }
        return sourceUrl;
    }

    protected void processSource(Map<String, String> textParameters, File basePath, Source source, Sink sink) throws MacroExecutionException {
        block15: {
            Source.Content content = source.getContent();
            Parser parser = this.getContentParser(source.getUrl(), textParameters);
            SnippetExtractor extractor = SnippetExtractor.getInstance();
            boolean verbatim = textParameters.containsKey("verbatim") ? Boolean.parseBoolean(textParameters.get("verbatim")) : parser == null;
            try {
                SortedMap<Integer, List<String>> snippets;
                SortedMap<Integer, List<String>> sortedMap = snippets = extractor.isSnippetSelectionRequired(source) ? extractor.selectSnippets(source) : null;
                if (verbatim) {
                    try {
                        if ("none".equalsIgnoreCase(textParameters.get("highlight-type"))) {
                            sink.verbatim(SinkEventAttributeSet.BOXED);
                            this.processRawContent(source, snippets, sink);
                            sink.verbatim_();
                        } else {
                            if (snippets == null) {
                                snippets = extractor.selectSnippets(source);
                            }
                            this.getHighlighter().execute(source.getUrl(), textParameters, snippets, sink);
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        throw new MacroExecutionException(String.valueOf(source), (Throwable)e);
                    }
                }
                if (parser == null) {
                    this.processRawContent(source, snippets, sink);
                    break block15;
                }
                Reader input = snippets == null ? content.openReader() : new StringReader(extractor.toString(snippets, false));
                try {
                    parser.parse(input, sink);
                }
                catch (ParseException e) {
                    throw new MacroExecutionException("Failed to parse content [\n" + IOUtil.toString((Reader)content.openReader()) + "\n] " + "loaded from " + source + " with parser " + parser.getClass(), (Throwable)e);
                }
                finally {
                    input.close();
                }
            }
            catch (RuntimeException e) {
                throw new MacroExecutionException(String.valueOf(source), (Throwable)e);
            }
            catch (IOException e) {
                throw new MacroExecutionException(String.valueOf(source), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRawContent(Source source, SortedMap<Integer, List<String>> snippets, Sink sink) throws IOException {
        if (snippets != null) {
            for (List<String> lines : snippets.values()) {
                for (String line : lines) {
                    sink.rawText(line);
                    sink.rawText(SnippetExtractor.LB);
                }
            }
        } else {
            BufferedReader reader = new BufferedReader(source.getContent().openReader());
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sink.rawText(line);
                    sink.rawText(SnippetExtractor.LB);
                }
            }
            finally {
                reader.close();
            }
        }
    }

    protected File findSiteAttachedIncludesDirectory(File basePath, Map<String, String> textParameters) {
        Log log = Globals.getLog();
        boolean useTargetOutput = Boolean.getBoolean("org.tinyjee.maven.dim.generateAttachedIncludesInBuildDirectory") || Boolean.getBoolean("dim.generateAttachedIncludesInBuildDirectory");
        File path = null;
        if (useTargetOutput) {
            String targetPath = System.getProperty("org.tinyjee.maven.dim.project.targetDirectory", "target");
            path = new File(basePath, targetPath + File.separator + "site");
            if (!path.isDirectory()) {
                log.warn((CharSequence)("The selected path '" + path + "' is not a directory. Cannot use generation of " + "attached includes inside the build target path, will inline scripts and CSS if needed."));
                path = null;
            } else {
                log.debug((CharSequence)("Using '" + path + "' to copy attached resources. Specify " + "'-Ddim.generateAttachedIncludesInBuildDirectory=false' if you need to use the more compatible " + "'copy-to-resource' folder operational mode."));
            }
        } else {
            File sitePath = this.findSiteSourceDirectory(basePath, textParameters);
            if (sitePath != null && !(path = new File(sitePath, RESOURCES_FOLDER_NAME)).isDirectory() && !path.mkdirs()) {
                log.warn((CharSequence)("Failed creating resource path '" + path + "'."));
                path = null;
            }
        }
        String attachedIncludesDirectory = Globals.getAttachedIncludesDirectory();
        if (!(path == null || StringUtils.isEmpty((String)attachedIncludesDirectory) || (path = new File(path, attachedIncludesDirectory)).isDirectory() || path.mkdirs())) {
            log.warn((CharSequence)("Failed creating attached includes path '" + path + "'."));
            path = null;
        }
        if (path == null) {
            log.warn((CharSequence)"No path could be determined to be used to attach includes content as files. Attaching arbitrary content will fail, while scripts and CSS will be inlined, when needed.");
        }
        return path;
    }

    protected File findSiteSourceDirectory(File baseDir, Map<String, String> params) {
        String siteDirectory = params.get("site-directory");
        if (siteDirectory == null) {
            siteDirectory = System.getProperty("org.tinyjee.maven.dim.project.siteDirectory");
        }
        File proposedSiteDir = StringUtils.isEmpty((String)siteDirectory) ? null : (ResourceResolver.isAbsolute(siteDirectory) ? new File(siteDirectory) : new File(baseDir, siteDirectory));
        return ResourceResolver.findSiteSourceDirectory(baseDir, proposedSiteDir);
    }

    protected Map<String, String> extractTextParameters(Map requestParameters) {
        HashMap<String, String> textParameters = new HashMap<String, String>(requestParameters.size());
        Iterator i$ = requestParameters.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            textParameters.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return textParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Parser getContentParser(URL source, Map<String, String> params) {
        String type = params.get("source-content-type");
        if (type == null && source != null) {
            type = FileUtils.extension((String)source.getFile());
        }
        AptParser parser = null;
        if (type != null) {
            if ("apt".equalsIgnoreCase(type)) {
                parser = new AptParser();
            } else if ("xdoc".equalsIgnoreCase(type)) {
                parser = new XdocParser();
            } else if ("fml".equalsIgnoreCase(type)) {
                parser = new FmlParser();
            }
            if (parser != null && this.container != null) {
                try {
                    MacroManager macroManager = (MacroManager)this.container.lookup(MacroManager.ROLE);
                    try {
                        Field macroManagerField = AbstractParser.class.getDeclaredField("macroManager");
                        macroManagerField.setAccessible(true);
                        macroManagerField.set(parser, macroManager);
                    }
                    finally {
                        this.container.release((Object)macroManager);
                    }
                }
                catch (Exception e) {
                    Globals.getLog().error((CharSequence)"Failed to configure parser, recursive macro execution will not work.", (Throwable)e);
                }
            }
        }
        return parser;
    }

    protected Log getLogger() {
        try {
            return (Log)((Object)((Object)this)).getClass().getMethod("getLog", new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception ignored) {
            return new SystemStreamLog();
        }
    }
}

