/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcePool<T> {
    private final LinkedList<T> pool;
    private final Set<T> allocated;
    private final Semaphore semaphore;
    private final IResourceFactory<T> resourceFactory;

    public ResourcePool(Collection<T> resources) {
        Validate.notNull(resources, "Resources for pool cannot be null");
        this.pool = new LinkedList<T>(resources);
        this.allocated = new HashSet<T>(this.pool.size() + 1, 1.0f);
        this.semaphore = new Semaphore(this.pool.size());
        this.resourceFactory = null;
    }

    public ResourcePool(IResourceFactory<T> resourceFactory, int poolSize) {
        Validate.notNull(resourceFactory, "Resource factory for pool cannot be null");
        this.resourceFactory = resourceFactory;
        this.pool = new LinkedList();
        for (int i = 0; i < poolSize; ++i) {
            T resource = this.resourceFactory.createResource();
            if (resource == null) {
                throw new IllegalStateException("Resource created by factory \"" + this.resourceFactory.getClass().getName() + "\"returned null");
            }
            this.pool.add(resource);
        }
        this.allocated = new HashSet<T>(this.pool.size() + 1, 1.0f);
        this.semaphore = new Semaphore(this.pool.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T allocate() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            T object = this.pool.removeFirst();
            this.allocated.add(object);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T resource) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            if (this.allocated.contains(resource)) {
                this.pool.addLast(resource);
                this.allocated.remove(resource);
            }
        }
        this.semaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardAndReplace(T resource) {
        if (this.resourceFactory == null) {
            throw new IllegalStateException("Cannot execute 'discardAndReplace' operation: no resource factory has been set.");
        }
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            if (this.allocated.contains(resource)) {
                T newResource = this.resourceFactory.createResource();
                this.pool.addLast(newResource);
                this.allocated.remove(resource);
            }
        }
        this.semaphore.release();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IResourceFactory<T> {
        public T createResource();
    }
}

