/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser;

import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class EntityResolver
implements org.xml.sax.EntityResolver {
    private static final Logger logger = LoggerFactory.getLogger(EntityResolver.class);
    private final Set<IDocTypeResolutionEntry> docTypeResolutionEntries;

    public EntityResolver(Configuration configuration) {
        this.docTypeResolutionEntries = configuration.getDocTypeResolutionEntries();
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        if (logger.isTraceEnabled()) {
            if (publicID == null) {
                logger.trace("[THYMELEAF][{}] Resolving entity SYSTEM \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)systemID);
            } else {
                logger.trace("[THYMELEAF][{}] Resolving entity PUBLIC \"{}\" \"{}\"", new Object[]{TemplateEngine.threadIndex(), publicID, systemID});
            }
        }
        for (IDocTypeResolutionEntry entry : this.docTypeResolutionEntries) {
            if (!entry.getPublicID().matches(publicID) || !entry.getSystemID().matches(systemID)) continue;
            return entry.createInputSource();
        }
        throw new TemplateProcessingException("Unsupported entity requested with PUBLICID \"" + publicID + "\" and " + "SYSTEMID \"" + systemID + "\". Make sure a corresponding " + IDocTypeResolutionEntry.class.getName() + " implementation is provided " + "by you dialect");
    }
}

