/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractLocalVariableDefinitionAttrProcessor;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardLocalVariableDefinitionAttrProcessor
extends AbstractLocalVariableDefinitionAttrProcessor {
    protected AbstractStandardLocalVariableDefinitionAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardLocalVariableDefinitionAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, Object> getNewLocalVariables(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        AssignationSequence assignations = AssignationUtils.parseAssignationSequence(configuration, arguments, attributeValue, false);
        if (assignations == null) {
            throw new TemplateProcessingException("Could not parse value as attribute assignations: \"" + attributeValue + "\"");
        }
        Arguments assignationExecutionArguments = arguments;
        HashMap<String, Object> newLocalVariables = new HashMap<String, Object>(assignations.size() + 1, 1.0f);
        for (Assignation assignation : assignations) {
            String newVariableName;
            IStandardExpression leftExpr = assignation.getLeft();
            Object leftValue = leftExpr.execute(configuration, assignationExecutionArguments);
            IStandardExpression rightExpr = assignation.getRight();
            Object rightValue = rightExpr.execute(configuration, assignationExecutionArguments);
            String string = newVariableName = leftValue == null ? null : leftValue.toString();
            if (StringUtils.isEmptyOrWhitespace(newVariableName)) {
                throw new TemplateProcessingException("Variable name expression evaluated as null or empty: \"" + leftExpr + "\"");
            }
            assignationExecutionArguments = assignationExecutionArguments.addLocalVariables(Collections.singletonMap(newVariableName, rightValue));
            newLocalVariables.put(newVariableName, rightValue);
        }
        return newLocalVariables;
    }
}

