/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.AdditionSubtractionExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.EvaluationUtil;

public final class AdditionExpression
extends AdditionSubtractionExpression {
    private static final long serialVersionUID = -971366486450425605L;
    private static final Logger logger = LoggerFactory.getLogger(AdditionExpression.class);

    public AdditionExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("+");
    }

    static Object executeAddition(Configuration configuration, IProcessingContext processingContext, AdditionExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating addition expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        IStandardVariableExpressionEvaluator expressionEvaluator = StandardExpressions.getVariableExpressionEvaluator(configuration);
        IStandardExpression leftExpr = expression.getLeft();
        IStandardExpression rightExpr = expression.getRight();
        Object leftValue = leftExpr instanceof Expression ? Expression.execute(configuration, processingContext, (Expression)leftExpr, expressionEvaluator, expContext) : leftExpr.execute(configuration, processingContext, expContext);
        Object rightValue = rightExpr instanceof Expression ? Expression.execute(configuration, processingContext, (Expression)rightExpr, expressionEvaluator, expContext) : rightExpr.execute(configuration, processingContext, expContext);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        BigDecimal leftNumberValue = EvaluationUtil.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtil.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            return leftNumberValue.add(rightNumberValue);
        }
        return new LiteralValue(LiteralValue.unwrap(leftValue).toString() + LiteralValue.unwrap(rightValue).toString());
    }
}

