/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.thymeleaf.context.VariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebSessionVariablesMap
extends VariablesMap<String, Object> {
    private static final long serialVersionUID = 3866833203758601975L;
    private final HttpServletRequest request;

    WebSessionVariablesMap(HttpServletRequest request) {
        super(1, 1.0f);
        this.request = request;
    }

    @Override
    public int size() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return 0;
        }
        int size = 0;
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNames.nextElement();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        HttpSession session = this.request.getSession(false);
        return session == null || !session.getAttributeNames().hasMoreElements();
    }

    @Override
    public Object get(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute((String)key);
    }

    @Override
    public boolean containsKey(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!(key == null ? attributeName == null : key.equals(attributeName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(String key, Object value) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Cannot put attribute into session: no HTTP session exists!");
        }
        session.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Cannot put attributes into session: no HTTP session exists!");
        }
        for (Map.Entry<String, ?> mEntry : m.entrySet()) {
            session.setAttribute(mEntry.getKey(), mEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Cannot remove attribute from session: no HTTP session exists!");
        }
        Object value = session.getAttribute((String)key);
        session.removeAttribute((String)key);
        return value;
    }

    @Override
    public void clear() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Cannot remove attribute from session: no HTTP session exists!");
        }
        ArrayList attributeNamesList = new ArrayList(5);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNamesList.add(attributeNames.nextElement());
        }
        for (String attributeName : attributeNamesList) {
            session.removeAttribute(attributeName);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = session.getAttribute(attributeName);
            if (!(value == null ? attributeValue == null : value.equals(attributeValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebSessionVariablesMap clone() {
        return (WebSessionVariablesMap)super.clone();
    }

    @Override
    public Set<String> keySet() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> keySet = new LinkedHashSet<String>(5);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            keySet.add((String)attributeNames.nextElement());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>(5);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            values.add(session.getAttribute(attributeName));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HttpSession session = this.request.getSession(false);
        return WebSessionVariablesMap.getAttributeMap(session).entrySet();
    }

    @Override
    public String toString() {
        HttpSession session = this.request.getSession(false);
        return WebSessionVariablesMap.getAttributeMap(session).toString();
    }

    @Override
    public int hashCode() {
        HttpSession session = this.request.getSession(false);
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + session.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSessionVariablesMap other = (WebSessionVariablesMap)obj;
        HttpSession session = this.request.getSession(false);
        HttpSession otherSession = other.request.getSession(false);
        return !(session == null ? otherSession != null : !session.equals(otherSession));
    }

    private static Map<String, Object> getAttributeMap(HttpSession session) {
        if (session == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(6, 1.0f);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = session.getAttribute(attributeName);
            attributeMap.put(attributeName, attributeValue);
        }
        return attributeMap;
    }
}

