/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebServletContextVariablesMap
extends VariablesMap<String, Object> {
    private static final long serialVersionUID = 6338751359164152136L;
    private final ServletContext servletContext;

    WebServletContextVariablesMap(ServletContext servletContext) {
        super(1, 1.0f);
        Validate.notNull(servletContext, "Servlet context cannot be null");
        this.servletContext = servletContext;
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNames.nextElement();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return !this.servletContext.getAttributeNames().hasMoreElements();
    }

    @Override
    public Object get(Object key) {
        return this.servletContext.getAttribute((String)key);
    }

    @Override
    public boolean containsKey(Object key) {
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!(key == null ? attributeName == null : key.equals(attributeName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(String key, Object value) {
        this.servletContext.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> mEntry : m.entrySet()) {
            this.servletContext.setAttribute(mEntry.getKey(), mEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        Object value = this.servletContext.getAttribute((String)key);
        this.servletContext.removeAttribute((String)key);
        return value;
    }

    @Override
    public void clear() {
        ArrayList attributeNamesList = new ArrayList(5);
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNamesList.add(attributeNames.nextElement());
        }
        for (String attributeName : attributeNamesList) {
            this.servletContext.removeAttribute(attributeName);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = this.servletContext.getAttribute(attributeName);
            if (!(value == null ? attributeValue == null : value.equals(attributeValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebServletContextVariablesMap clone() {
        return (WebServletContextVariablesMap)super.clone();
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>(5);
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            keySet.add((String)attributeNames.nextElement());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(5);
        Enumeration attributeNames = this.servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            values.add(this.servletContext.getAttribute(attributeName));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return WebServletContextVariablesMap.getAttributeMap(this.servletContext).entrySet();
    }

    @Override
    public String toString() {
        return WebServletContextVariablesMap.getAttributeMap(this.servletContext).toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.servletContext.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebServletContextVariablesMap other = (WebServletContextVariablesMap)obj;
        return !(this.servletContext == null ? other.servletContext != null : !this.servletContext.equals(other.servletContext));
    }

    private static Map<String, Object> getAttributeMap(ServletContext servletContext) {
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(6, 1.0f);
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = servletContext.getAttribute(attributeName);
            attributeMap.put(attributeName, attributeValue);
        }
        return attributeMap;
    }
}

