/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.thymeleaf.context.IContextVariableRestriction;
import org.thymeleaf.context.OGNLVariablesMapPropertyAccessor;
import org.thymeleaf.exceptions.TemplateProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariablesMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 6785956724279950873L;
    private List<IContextVariableRestriction> restrictions = null;

    public VariablesMap() {
    }

    public VariablesMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public VariablesMap(int initialCapacity) {
        super(initialCapacity);
    }

    public VariablesMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public List<IContextVariableRestriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<IContextVariableRestriction> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public V get(Object key) {
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            for (IContextVariableRestriction restriction : this.restrictions) {
                if (restriction == null) continue;
                restriction.checkAccess(this, (String)key);
            }
        }
        return super.get(key);
    }

    @Override
    public VariablesMap<K, V> clone() {
        return (VariablesMap)super.clone();
    }

    static {
        try {
            Class.forName("ognl.OgnlRuntime");
            OGNLVariablesMapPropertyAccessor.initialize();
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception while configuring OGNL variables map property accessor", e);
        }
    }
}

